/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.delegating;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.impl.VertxInternal;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.client.amqp.connection.ConnectionFactory;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.auth.AbstractHonoAuthenticationService;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClient;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClientConfigProperties;

public class DelegatingAuthenticationService
extends AbstractHonoAuthenticationService<AuthenticationServerClientConfigProperties>
implements HealthCheckProvider {
    private AuthenticationServerClient client;
    private ConnectionFactory factory;
    private DnsClient dnsClient;

    @Override
    public final String[] getSupportedSaslMechanisms() {
        return Optional.ofNullable((AuthenticationServerClientConfigProperties)((Object)this.getConfig())).map(config -> config.getSupportedSaslMechanisms().toArray(new String[0])).orElse(DEFAULT_SASL_MECHANISMS);
    }

    public void setDnsClient(DnsClient dnsClient) {
        this.dnsClient = Objects.requireNonNull(dnsClient);
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.factory = Objects.requireNonNull(connectionFactory);
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        if (this.dnsClient != null) {
            this.log.info("registering readiness check using DNS Client");
            readinessHandler.register("authentication-service-availability", status -> {
                this.log.trace("checking availability of Authentication service");
                this.dnsClient.lookup(((AuthenticationServerClientConfigProperties)((Object)((Object)this.getConfig()))).getHost(), lookupAttempt -> {
                    if (lookupAttempt.succeeded()) {
                        status.tryComplete((Object)Status.OK());
                    } else {
                        this.log.debug("readiness check failed to resolve Authentication service address [{}]: {}", (Object)((AuthenticationServerClientConfigProperties)((Object)((Object)((Object)this.getConfig())))).getHost(), (Object)lookupAttempt.cause().getMessage());
                        status.tryComplete((Object)Status.KO());
                    }
                });
            });
        } else {
            Vertx vertx = this.vertx;
            if (vertx instanceof VertxInternal) {
                VertxInternal vertxInternal = (VertxInternal)vertx;
                this.log.info("registering readiness check using vert.x Address Resolver");
                readinessHandler.register("authentication-service-availability", status -> {
                    this.log.trace("checking availability of Authentication service");
                    vertxInternal.resolveAddress(((AuthenticationServerClientConfigProperties)((Object)((Object)this.getConfig()))).getHost(), lookupAttempt -> {
                        if (lookupAttempt.succeeded()) {
                            status.tryComplete((Object)Status.OK());
                        } else {
                            this.log.debug("readiness check failed to resolve Authentication service address [{}]: {}", (Object)((AuthenticationServerClientConfigProperties)((Object)((Object)((Object)this.getConfig())))).getHost(), (Object)lookupAttempt.cause().getMessage());
                            status.tryComplete((Object)Status.KO());
                        }
                    });
                });
            } else {
                this.log.warn("cannot register readiness check, no DNS resolver available");
            }
        }
    }

    @Override
    protected final void doStart(Promise<Void> startFuture) {
        if (this.factory == null) {
            startFuture.fail((Throwable)new IllegalStateException("no connection factory for Authentication service set"));
        } else {
            this.client = new AuthenticationServerClient(this.vertx, this.factory);
            if (this.log.isInfoEnabled()) {
                String saslMechanisms = ((AuthenticationServerClientConfigProperties)((Object)this.getConfig())).getSupportedSaslMechanisms().stream().collect(Collectors.joining(", "));
                this.log.info("starting {} with support for SASL mechanisms: {}", (Object)this, (Object)saslMechanisms);
            }
            startFuture.complete();
        }
    }

    @Override
    public Future<HonoUser> verifyExternal(String authzid, String subjectDn) {
        return this.client.verifyExternal(authzid, subjectDn);
    }

    @Override
    public Future<HonoUser> verifyPlain(String authzid, String authcid, String password) {
        return this.client.verifyPlain(authzid, authcid, password);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + "Authentication service: " + ((AuthenticationServerClientConfigProperties)((Object)this.getConfig())).getHost() + ":" + ((AuthenticationServerClientConfigProperties)((Object)this.getConfig())).getPort() + "]";
    }
}

