/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.delegating;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithParentName;
import java.time.Duration;
import java.util.List;
import org.eclipse.hono.client.amqp.config.ClientOptions;
import org.eclipse.hono.service.auth.SignatureSupportingOptions;

@ConfigMapping(prefix="hono.auth.client", namingStrategy=ConfigMapping.NamingStrategy.VERBATIM)
public interface AuthenticationServerClientOptions {
    public static final String DEFAULT_JWKS_ENDPOINT_URI = "/validating-keys";

    @WithParentName
    public ClientOptions clientOptions();

    public SignatureSupportingOptions validation();

    @WithDefault(value="EXTERNAL,PLAIN")
    public List<String> supportedSaslMechanisms();

    @WithDefault(value="8088")
    public int jwksEndpointPort();

    @WithDefault(value="/validating-keys")
    public String jwksEndpointUri();

    @WithDefault(value="false")
    public boolean jwksEndpointTlsEnabled();

    @WithDefault(value="PT5M")
    public Duration jwksPollingInterval();

    @WithDefault(value="false")
    public boolean jwksSignatureAlgorithmRequired();
}

