/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.LocatorAdapter;
import io.jsonwebtoken.io.Parser;
import io.jsonwebtoken.security.JwkSet;
import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SecurityException;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import java.security.Key;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.hono.service.auth.AuthTokenValidator;
import org.eclipse.hono.service.auth.JwtSupport;
import org.eclipse.hono.service.auth.SignatureSupportingConfigProperties;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClientConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JjwtBasedAuthTokenValidator
extends JwtSupport
implements AuthTokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JjwtBasedAuthTokenValidator.class);
    private final SignatureSupportingConfigProperties config;
    private final AtomicLong nextJwksPollingTask = new AtomicLong(-1L);
    private final AtomicBoolean jwksPollingInProgress = new AtomicBoolean(false);
    private HttpClient httpClient;
    private RequestOptions requestOptions;
    private long pollingIntervalMillis = 300000L;
    private boolean isJwksSignatureAlgorithmRequired = true;

    public JjwtBasedAuthTokenValidator(Vertx vertx, SignatureSupportingConfigProperties config) {
        super(vertx);
        Objects.requireNonNull(config);
        this.useConfiguredKeys(config);
        this.config = config;
    }

    public JjwtBasedAuthTokenValidator(Vertx vertx, AuthenticationServerClientConfigProperties authServerClientConfig) {
        super(vertx);
        Objects.requireNonNull(authServerClientConfig);
        try {
            this.useConfiguredKeys(authServerClientConfig.getValidation());
        }
        catch (IllegalArgumentException e) {
            LOG.info("using JWK set retrieved from Authentication service for validating tokens");
            this.isJwksSignatureAlgorithmRequired = authServerClientConfig.isJwksSignatureAlgorithmRequired();
            this.pollingIntervalMillis = authServerClientConfig.getJwksPollingInterval().toMillis();
            HttpClientOptions clientOptions = new HttpClientOptions().setTrustOptions(authServerClientConfig.getTrustOptions());
            this.httpClient = vertx.createHttpClient(clientOptions);
            this.requestOptions = new RequestOptions().setTraceOperation("get token-validation keys").setHost(authServerClientConfig.getHost()).setPort(Integer.valueOf(authServerClientConfig.getJwksEndpointPort())).setSsl(Boolean.valueOf(authServerClientConfig.isJwksEndpointTlsEnabled())).setURI(authServerClientConfig.getJwksEndpointUri()).setMethod(HttpMethod.GET).addHeader(HttpHeaders.ACCEPT, (CharSequence)"application/jwk-set+json").setTimeout(2000L);
            this.requestJwkSet();
        }
        this.config = authServerClientConfig.getValidation();
    }

    private void useConfiguredKeys(SignatureSupportingConfigProperties config) {
        block4: {
            try {
                if (config.getSharedSecret() != null) {
                    byte[] secret = JjwtBasedAuthTokenValidator.getBytes(config.getSharedSecret());
                    this.addSecretKey(Keys.hmacShaKeyFor((byte[])secret));
                    LOG.info("using shared secret [{} bytes] for validating tokens", (Object)secret.length);
                    break block4;
                }
                if (config.getCertPath() != null) {
                    this.setPublicKey(config.getCertPath());
                    LOG.info("using public key from certificate [{}] for validating tokens", (Object)config.getCertPath());
                    break block4;
                }
                throw new IllegalArgumentException("configuration does not specify any key material for validating tokens");
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("failed to create validator for configured key material", e);
            }
        }
    }

    private void requestJwkSet() {
        if (!this.jwksPollingInProgress.compareAndSet(false, true)) {
            return;
        }
        this.vertx.cancelTimer(this.nextJwksPollingTask.get());
        LOG.debug("requesting JWK set from http{}://{}:{}{}", new Object[]{this.requestOptions.isSsl() != false ? "s" : "", this.requestOptions.getHost(), this.requestOptions.getPort(), this.requestOptions.getURI()});
        this.httpClient.request(this.requestOptions).compose(HttpClientRequest::send).compose(HttpClientResponse::body).map(Buffer::toString).map(jsonString -> {
            JwkSet jwkSet = (JwkSet)((Parser)Jwks.setParser().build()).parse((CharSequence)jsonString);
            if (LOG.isDebugEnabled()) {
                LOG.debug("server returned JWK set:{}{}", (Object)System.lineSeparator(), (Object)jwkSet.toString());
            }
            if (jwkSet.isEmpty()) {
                LOG.warn("server returned empty key set, won't be able to validate tokens");
            }
            return jwkSet;
        }).onSuccess(jwkSet -> {
            HashMap<String, Key> keys = new HashMap<String, Key>();
            jwkSet.forEach(jwk -> {
                if (this.isJwksSignatureAlgorithmRequired && jwk.getAlgorithm() == null) {
                    LOG.warn("JSON Web Key [id: {}] does not contain required alg property, skipping key ...", (Object)jwk.getId());
                } else {
                    keys.put(jwk.getId(), jwk.toKey());
                }
            });
            this.setValidatingKeys(keys);
            LOG.debug("successfully retrieved JWK set of {} key(s)", (Object)keys.size());
            this.nextJwksPollingTask.set(this.vertx.setTimer(this.pollingIntervalMillis, tid -> this.requestJwkSet()));
        }).onFailure(t -> {
            LOG.warn("failed to retrieve JWK set from server, will try again in 3s ...", t);
            this.nextJwksPollingTask.set(this.vertx.setTimer(3000L, tid -> this.requestJwkSet()));
        }).onComplete(ar -> this.jwksPollingInProgress.set(false));
    }

    @Override
    public Jws<Claims> expand(String token) {
        Objects.requireNonNull(token);
        JwtParserBuilder builder = Jwts.parser().requireIssuer(this.config.getIssuer()).keyLocator((Locator)new LocatorAdapter<Key>(){

            public Key locate(JwsHeader header) {
                String keyId = header.getKeyId();
                if (keyId == null) {
                    LOG.debug("token has no kid header, will try to use default key for validating signature");
                    return JjwtBasedAuthTokenValidator.this.getValidatingKey();
                }
                Key validatingKey = JjwtBasedAuthTokenValidator.this.getValidatingKey(keyId);
                if (validatingKey == null) {
                    LOG.debug("unknown validating key [id: {}], refreshing JWK set ...", (Object)keyId);
                    JjwtBasedAuthTokenValidator.this.requestJwkSet();
                    return null;
                }
                return validatingKey;
            }
        });
        Optional.ofNullable(this.config.getAudience()).ifPresent(arg_0 -> ((JwtParserBuilder)builder).requireAudience(arg_0));
        return builder.build().parseSignedClaims((CharSequence)token);
    }
}

