/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.amqp;

import java.util.Optional;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRequestMessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(GenericRequestMessageFilter.class);

    protected GenericRequestMessageFilter() {
    }

    public static boolean isValidRequestMessage(Message msg) {
        Object correlationId = Optional.ofNullable(msg.getCorrelationId()).orElseGet(() -> ((Message)msg).getMessageId());
        if (correlationId == null) {
            LOG.trace("message has neither a message-id nor correlation-id");
            return false;
        }
        if (msg.getSubject() == null) {
            LOG.trace("message [correlation ID: {}] does not contain a subject", correlationId);
            return false;
        }
        if (msg.getReplyTo() == null) {
            LOG.trace("message [correlation ID: {}] contains no reply-to address", correlationId);
            return false;
        }
        return true;
    }
}

