/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.SignatureException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.service.auth.AuthTokenValidator;
import org.eclipse.hono.util.CredentialsObject;

public class ExternalJwtAuthTokenValidator
implements AuthTokenValidator {
    static final int ALLOWED_CLOCK_SKEW = 600;
    private static final String EXPECTED_TOKEN_TYPE = "JWT";
    private CredentialsObject credentialsObject;

    public static Instant getExpirationTime(Instant exp) {
        return exp.plusSeconds(600L);
    }

    public CredentialsObject getCredentialsObject() {
        return this.credentialsObject;
    }

    public void setCredentialsObject(CredentialsObject credentialsObject) {
        this.credentialsObject = credentialsObject;
    }

    @Override
    public Jws<Claims> expand(String token) {
        Jws claims;
        Objects.requireNonNull(token);
        SignatureException signatureException = null;
        JwtParserBuilder builder = Jwts.parserBuilder().setAllowedClockSkewSeconds(600L);
        int i = 0;
        while (true) {
            try {
                final int index = i;
                builder.setSigningKeyResolver((SigningKeyResolver)new SigningKeyResolverAdapter(){

                    public Key resolveSigningKey(JwsHeader header, Claims claims) {
                        String tokenType = Optional.ofNullable(header.getType()).orElseThrow(() -> new MalformedJwtException("token does not contain required typ header."));
                        if (!tokenType.equalsIgnoreCase(ExternalJwtAuthTokenValidator.EXPECTED_TOKEN_TYPE)) {
                            throw new MalformedJwtException(String.format("typ field in token header is invalid. Must be \"%s\".", ExternalJwtAuthTokenValidator.EXPECTED_TOKEN_TYPE));
                        }
                        String algorithm = Optional.ofNullable(header.getAlgorithm()).orElseThrow(() -> new MalformedJwtException("token does not contain required alg header."));
                        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forName((String)algorithm);
                        ExternalJwtAuthTokenValidator.this.checkValidityOfExpirationAndCreationTime(claims.getExpiration(), claims.getIssuedAt());
                        claims.setNotBefore(claims.getIssuedAt());
                        List secrets = ExternalJwtAuthTokenValidator.this.getCredentialsObject().getCandidateSecrets();
                        List<JsonObject> validSecretsList = secrets.stream().filter(secret -> signatureAlgorithm.getFamilyName().startsWith(secret.getString("algorithm"))).toList();
                        byte[] encodedPublicKey = Objects.requireNonNull(validSecretsList.get(index).getBinary("key"));
                        return ExternalJwtAuthTokenValidator.this.convertPublicKeyByteArrayToPublicKey(encodedPublicKey, signatureAlgorithm);
                    }
                });
                claims = builder.build().parseClaimsJws(token);
                break;
            }
            catch (SignatureException e) {
                signatureException = e;
            }
            catch (IndexOutOfBoundsException e) {
                if (signatureException != null) {
                    throw signatureException;
                }
                throw new NoSuchElementException("There is no valid raw public key (\"rpk\") saved with the same algorithm as the provided JWT.");
            }
            ++i;
        }
        return claims;
    }

    public JsonObject getJwtClaims(String jws) {
        Objects.requireNonNull(jws);
        String[] jwtSplit = jws.split("\\.", 3);
        if (jwtSplit.length != 3) {
            throw new MalformedJwtException("String is not a valid JWS structure");
        }
        try {
            Buffer p = Buffer.buffer((byte[])Base64.getUrlDecoder().decode(jwtSplit[1]));
            return new JsonObject(p);
        }
        catch (RuntimeException e) {
            throw new MalformedJwtException("Cannot parse JWS payload into JSON object", (Throwable)e);
        }
    }

    private void checkValidityOfExpirationAndCreationTime(Date expDate, Date iatDate) {
        Instant iat;
        Instant exp;
        try {
            exp = expDate.toInstant();
            iat = iatDate.toInstant();
        }
        catch (NullPointerException e) {
            throw new UnsupportedJwtException("iat and exp claims must be provided in JWT payload.");
        }
        Instant startOfValidity = Instant.now().minusSeconds(600L);
        int validityPeriodHours = 24;
        Instant endOfValidity = iat.plusSeconds(87000L);
        if (iat.isBefore(startOfValidity)) {
            throw new UnsupportedJwtException(String.format("Timestamp in iat claim must be at most %s seconds before the current timestamp.", 600));
        }
        if (!exp.isAfter(iat)) {
            throw new UnsupportedJwtException("Timestamp in exp claim must not be before timestamp in iat claim.");
        }
        if (exp.isAfter(endOfValidity)) {
            throw new UnsupportedJwtException(String.format("Timestamp in exp claim must be at most %s hours after the iat claim with a skew of %s seconds.", 24, 600));
        }
    }

    private PublicKey convertPublicKeyByteArrayToPublicKey(byte[] encodedPublicKey, SignatureAlgorithm alg) {
        PublicKey publicKey;
        X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(encodedPublicKey);
        try {
            KeyFactory keyFactory;
            if (alg.isRsa()) {
                keyFactory = KeyFactory.getInstance("RSA");
            } else if (alg.isEllipticCurve()) {
                keyFactory = KeyFactory.getInstance("EC");
            } else {
                throw new RuntimeException("Provided algorithm is not supported.");
            }
            publicKey = keyFactory.generatePublic(keySpecX509);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        return publicKey;
    }
}

