/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpServerSpanHelper {
    public static final String ROUTING_CONTEXT_SPAN_KEY = HttpServerSpanHelper.class.getName() + ".serverSpan";
    private static final Logger LOG = LoggerFactory.getLogger(HttpServerSpanHelper.class);

    private HttpServerSpanHelper() {
    }

    public static void adoptActiveSpanIntoContext(Tracer tracer, Map<String, String> customTags, RoutingContext routingContext) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(customTags);
        Objects.requireNonNull(routingContext);
        if (routingContext.get(ROUTING_CONTEXT_SPAN_KEY) == null) {
            Optional.ofNullable(tracer.activeSpan()).ifPresentOrElse(span -> {
                customTags.forEach((arg_0, arg_1) -> ((Span)span).setTag(arg_0, arg_1));
                routingContext.put(ROUTING_CONTEXT_SPAN_KEY, span);
            }, () -> LOG.warn("no active span set"));
        }
    }

    public static SpanContext serverSpanContext(RoutingContext routingContext) {
        return Optional.ofNullable(HttpServerSpanHelper.serverSpan(routingContext)).map(Span::context).orElse(null);
    }

    public static Span serverSpan(RoutingContext routingContext) {
        Objects.requireNonNull(routingContext);
        return Optional.ofNullable(routingContext.get(ROUTING_CONTEXT_SPAN_KEY)).filter(Span.class::isInstance).map(Span.class::cast).orElse(null);
    }
}

