/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.util.Lifecycle;

public abstract class AbstractDelegatingHttpEndpoint<S, T extends ServiceConfigProperties>
extends AbstractHttpEndpoint<T> {
    protected S service;

    public AbstractDelegatingHttpEndpoint(Vertx vertx, S service) {
        super(vertx);
        Objects.requireNonNull(service);
        this.logger.debug("using service instance: {}", service);
        this.service = service;
    }

    protected static <T> Future<List<T>> decodeJsonFromRequestParameter(RoutingContext ctx, String paramKey, Class<T> clazz) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(paramKey);
        Objects.requireNonNull(clazz);
        Promise result = Promise.promise();
        try {
            List values = ctx.request().params().getAll(paramKey).stream().map(json -> Json.decodeValue((String)json, (Class)clazz)).collect(Collectors.toList());
            result.complete(values);
        }
        catch (DecodeException e) {
            result.fail((Throwable)new ClientErrorException(400, String.format("error parsing json value of parameter [%s]", paramKey), (Throwable)e));
        }
        return result.future();
    }

    protected final S getService() {
        return this.service;
    }

    @Override
    protected void doStart(Promise<Void> startPromise) {
        if (this.service instanceof Lifecycle) {
            ((Lifecycle)this.service).start().onComplete(startPromise);
        } else {
            startPromise.complete();
        }
    }

    @Override
    protected void doStop(Promise<Void> stopPromise) {
        if (this.service instanceof Lifecycle) {
            ((Lifecycle)this.service).stop().onComplete(stopPromise);
        } else {
            stopPromise.complete();
        }
    }
}

