/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.delegating.quarkus;

import io.quarkus.arc.properties.IfBuildProperty;
import io.smallrye.config.ConfigMapping;
import io.smallrye.health.api.HealthRegistry;
import io.vertx.core.Vertx;
import io.vertx.proton.sasl.ProtonSaslAuthenticatorFactory;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.client.amqp.connection.ConnectionFactory;
import org.eclipse.hono.service.auth.AuthenticationService;
import org.eclipse.hono.service.auth.HonoSaslAuthenticatorFactory;
import org.eclipse.hono.service.auth.JjwtBasedAuthTokenValidator;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClientConfigProperties;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClientOptions;
import org.eclipse.hono.service.auth.delegating.DelegatingAuthenticationService;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Readiness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@IfBuildProperty(name="hono.auth", stringValue="delegating")
public class DelegatingAuthenticationServiceProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingAuthenticationServiceProducer.class);

    @Produces
    @Singleton
    AuthenticationServerClientConfigProperties authenticationServerClientProperties(@ConfigMapping(prefix="hono.auth") AuthenticationServerClientOptions options) {
        AuthenticationServerClientConfigProperties props = new AuthenticationServerClientConfigProperties(options);
        props.setServerRoleIfUnknown("Authentication Server");
        return props;
    }

    @Produces
    @Singleton
    AuthenticationService delegatingAuthenticationService(Vertx vertx, AuthenticationServerClientConfigProperties authServerClientConfig) {
        LOG.info("creating {} instance", (Object)DelegatingAuthenticationService.class.getName());
        DelegatingAuthenticationService service = new DelegatingAuthenticationService();
        service.setConfig((Object)authServerClientConfig);
        service.setConnectionFactory(ConnectionFactory.newConnectionFactory((Vertx)vertx, (ClientConfigProperties)authServerClientConfig));
        return service;
    }

    @Produces
    @Singleton
    ProtonSaslAuthenticatorFactory honoSaslAuthenticatorFactory(Vertx vertx, AuthenticationServerClientConfigProperties authServerClientConfig, AuthenticationService authenticationService, @Readiness HealthRegistry readinessChecks) {
        JjwtBasedAuthTokenValidator authTokenValidator = new JjwtBasedAuthTokenValidator(vertx, authServerClientConfig);
        readinessChecks.register(() -> HealthCheckResponse.builder().name("AuthTokenValidator").status(authTokenValidator.hasValidatingKey()).build());
        return new HonoSaslAuthenticatorFactory(vertx, authTokenValidator, authenticationService);
    }
}

