/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.opentracing.Tracer;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.notification.amqp.ProtonBasedNotificationReceiver;
import org.eclipse.hono.client.notification.kafka.KafkaBasedNotificationReceiver;
import org.eclipse.hono.client.notification.kafka.NotificationKafkaConsumerConfigProperties;
import org.eclipse.hono.client.util.ServiceClient;
import org.eclipse.hono.notification.NotificationConstants;
import org.eclipse.hono.notification.NotificationEventBusSupport;
import org.eclipse.hono.notification.NotificationReceiver;
import org.eclipse.hono.notification.NotificationType;
import org.eclipse.hono.service.AbstractServiceApplication;
import org.eclipse.hono.service.util.ServiceClientAdapter;

public abstract class NotificationSupportingServiceApplication
extends AbstractServiceApplication {
    protected NotificationReceiver notificationReceiver(NotificationKafkaConsumerConfigProperties kafkaNotificationConfig, ClientConfigProperties amqpNotificationConfig) {
        KafkaBasedNotificationReceiver notificationReceiver;
        if (!this.appConfig.isKafkaMessagingDisabled() && kafkaNotificationConfig.isConfigured()) {
            notificationReceiver = new KafkaBasedNotificationReceiver(this.vertx, kafkaNotificationConfig);
        } else if (!this.appConfig.isAmqpMessagingDisabled() && amqpNotificationConfig.isHostConfigured()) {
            ClientConfigProperties notificationConfig = new ClientConfigProperties(amqpNotificationConfig);
            notificationConfig.setServerRole("Notification");
            notificationReceiver = new ProtonBasedNotificationReceiver(HonoConnection.newConnection((Vertx)this.vertx, (ClientConfigProperties)notificationConfig, (Tracer)this.tracer));
        } else {
            throw new IllegalStateException("at least one of Kafka or AMQP messaging must be configured");
        }
        if (notificationReceiver instanceof ServiceClient) {
            ServiceClient serviceClient = (ServiceClient)notificationReceiver;
            this.healthCheckServer.registerHealthCheckResources(ServiceClientAdapter.forClient(serviceClient));
        }
        Handler notificationSender = NotificationEventBusSupport.getNotificationSender((Vertx)this.vertx);
        NotificationConstants.DEVICE_REGISTRY_NOTIFICATION_TYPES.forEach(arg_0 -> NotificationSupportingServiceApplication.lambda$notificationReceiver$0((NotificationReceiver)notificationReceiver, notificationSender, arg_0));
        return notificationReceiver;
    }

    private static /* synthetic */ void lambda$notificationReceiver$0(NotificationReceiver notificationReceiver, Handler notificationSender, NotificationType notificationType) {
        notificationReceiver.registerConsumer(notificationType, arg_0 -> ((Handler)notificationSender).handle(arg_0));
    }
}

