/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.delegating;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonMessageHandler;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.sasl.MechanismMismatchException;
import java.util.Objects;
import java.util.Optional;
import javax.security.sasl.AuthenticationException;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.auth.HonoUserAdapter;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.client.amqp.connection.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticationServerClient {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationServerClient.class);
    private final ConnectionFactory factory;
    private final Vertx vertx;

    public AuthenticationServerClient(Vertx vertx, ConnectionFactory connectionFactory) {
        this.vertx = Objects.requireNonNull(vertx);
        this.factory = Objects.requireNonNull(connectionFactory);
    }

    public Future<HonoUser> verifyExternal(String authzid, String subjectDn) {
        return Future.failedFuture((Throwable)new ClientErrorException(400, "unsupported mechanism"));
    }

    public Future<HonoUser> verifyPlain(String authzid, String authcid, String password) {
        ProtonClientOptions options = new ProtonClientOptions();
        options.setReconnectAttempts(3).setReconnectInterval(50L);
        options.addEnabledSaslMechanism("PLAIN");
        Future connectAttempt = this.factory.connect(options, authcid, password, null, null);
        return connectAttempt.compose(openCon -> this.getToken((ProtonConnection)openCon)).recover(t -> Future.failedFuture((Throwable)this.mapConnectionFailureToServiceInvocationException((Throwable)t))).onComplete(s -> Optional.ofNullable((ProtonConnection)connectAttempt.result()).ifPresent(con -> {
            LOG.debug("closing connection to Authentication service");
            con.close();
        }));
    }

    private ServiceInvocationException mapConnectionFailureToServiceInvocationException(Throwable connectionFailureCause) {
        Object exception = connectionFailureCause instanceof AuthenticationException ? new ClientErrorException(401, "failed to authenticate with Authentication service") : (connectionFailureCause instanceof MechanismMismatchException ? new ClientErrorException(401, "Authentication service does not support SASL mechanism") : new ServerErrorException(503, "failed to connect to Authentication service", connectionFailureCause));
        LOG.debug("mapped exception [{}] thrown during SASL handshake to [{}]", (Object)connectionFailureCause.getClass().getName(), (Object)exception.getClass().getName());
        return exception;
    }

    private Future<HonoUser> getToken(ProtonConnection openCon) {
        Promise result = Promise.promise();
        ProtonMessageHandler messageHandler = (delivery, message) -> {
            String type = (String)AmqpUtils.getApplicationProperty((Message)message, (String)"type", String.class);
            if ("amqp:jwt".equals(type)) {
                final String payload = AmqpUtils.getPayloadAsString((Message)message);
                if (payload != null) {
                    HonoUserAdapter user = new HonoUserAdapter(){

                        public String getToken() {
                            return payload;
                        }
                    };
                    LOG.debug("successfully retrieved token from Authentication service");
                    result.complete((Object)user);
                } else {
                    result.fail((Throwable)new ServerErrorException(500, "message from Authentication service contains no body"));
                }
            } else {
                result.fail((Throwable)new ServerErrorException(500, "Authentication service issued unsupported token [type: " + type + "]"));
            }
        };
        AuthenticationServerClient.openReceiver(openCon, messageHandler).onComplete(attempt -> {
            if (attempt.succeeded()) {
                this.vertx.setTimer(5000L, tid -> result.tryFail((Throwable)new ServerErrorException(503, "time out reached while waiting for token from Authentication service")));
                LOG.debug("opened receiver link to Authentication service, waiting for token ...");
            } else {
                result.fail(attempt.cause());
            }
        });
        return result.future();
    }

    private static Future<ProtonReceiver> openReceiver(ProtonConnection openConnection, ProtonMessageHandler messageHandler) {
        Promise result = Promise.promise();
        ProtonReceiver recv = openConnection.createReceiver("cbs");
        recv.openHandler((Handler)result);
        recv.handler(messageHandler);
        recv.open();
        return result.future();
    }
}

