/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.eclipse.hono.service.auth.EncodedPassword;
import org.springframework.security.crypto.password.PasswordEncoder;

public class MessageDigestPasswordEncoder
implements PasswordEncoder {
    private static final Character PREFIX = Character.valueOf('{');
    private static final Character SUFFIX = Character.valueOf('}');
    private final SecureRandom rng;
    private final String hashFunction;

    public MessageDigestPasswordEncoder(String hashFunction) {
        this(hashFunction, new SecureRandom());
    }

    public MessageDigestPasswordEncoder(String hashFunction, SecureRandom rng) {
        Objects.requireNonNull(hashFunction);
        Objects.requireNonNull(rng);
        try {
            MessageDigest.getInstance(hashFunction);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("hash function [" + hashFunction + "] not supported on JVM", e);
        }
        this.hashFunction = hashFunction;
        this.rng = rng;
    }

    public String encode(CharSequence rawPassword) {
        byte[] salt = this.randomSalt();
        return PREFIX + Base64.getEncoder().encodeToString(salt) + SUFFIX + Base64.getEncoder().encodeToString(this.digest(salt, rawPassword.toString()));
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        EncodedPassword password = new EncodedPassword(encodedPassword);
        byte[] digested = this.digest(password.salt, rawPassword.toString());
        byte[] pwdHash = Base64.getDecoder().decode(password.password);
        return Arrays.equals(digested, pwdHash);
    }

    private byte[] digest(byte[] salt, String password) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.hashFunction);
            if (salt != null) {
                messageDigest.update(salt);
            }
            return messageDigest.digest(password.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("hash function [" + this.hashFunction + "] not supported on JVM", e);
        }
    }

    private byte[] randomSalt() {
        byte[] salt = new byte[8];
        this.rng.nextBytes(salt);
        return salt;
    }
}

