/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.Objects;
import org.eclipse.hono.util.CredentialsConstants;

public final class EncodedPassword {
    private static final String PREFIX = "{";
    private static final String SUFFIX = "}";
    public byte[] salt;
    public String password;
    public String hashFunction = "sha-256";

    private EncodedPassword() {
    }

    public EncodedPassword(String formattedPassword) {
        this.parse(formattedPassword);
    }

    public static EncodedPassword fromHonoSecret(JsonObject secret) throws IllegalArgumentException {
        Objects.requireNonNull(secret);
        String pwdHash = CredentialsConstants.getPasswordHash((JsonObject)secret);
        if (pwdHash == null) {
            throw new IllegalArgumentException("hashed-password secret does not contain a pwd hash");
        }
        String hashFunction = CredentialsConstants.getHashFunction((JsonObject)secret);
        String encodedSalt = CredentialsConstants.getPasswordSalt((JsonObject)secret);
        EncodedPassword encodedPassword = new EncodedPassword();
        encodedPassword.hashFunction = hashFunction;
        encodedPassword.password = pwdHash;
        if (encodedSalt != null) {
            encodedPassword.salt = Base64.getDecoder().decode(encodedSalt);
        }
        return encodedPassword;
    }

    private void parse(String formattedPassword) {
        int end;
        Objects.requireNonNull(formattedPassword);
        int start = formattedPassword.indexOf(PREFIX);
        this.password = formattedPassword;
        if (start == 0 && (end = formattedPassword.indexOf(SUFFIX, start)) > 0) {
            this.salt = Base64.getDecoder().decode(formattedPassword.substring(start + 1, end));
            this.password = formattedPassword.substring(end + 1);
        }
    }

    public String format() {
        StringBuilder result = new StringBuilder();
        EncodedPassword.append(this.salt, result);
        result.append(this.password);
        return result.toString();
    }

    private static void append(byte[] value, StringBuilder builder) {
        if (value != null) {
            builder.append(PREFIX).append(Base64.getEncoder().encodeToString(value)).append(SUFFIX);
        }
    }
}

