/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.login.CredentialException;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.auth.BaseAuthenticationService;
import org.eclipse.hono.util.AuthenticationConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHonoAuthenticationService<T>
extends BaseAuthenticationService<T> {
    protected static final String[] DEFAULT_SASL_MECHANISMS = new String[]{"EXTERNAL", "PLAIN"};
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String[] getSupportedSaslMechanisms() {
        return DEFAULT_SASL_MECHANISMS;
    }

    public static boolean isCompatibleSaslMechanism(String mechanism) {
        return "EXTERNAL".equals(mechanism) || "PLAIN".equals(mechanism);
    }

    @Override
    public final Future<HonoUser> authenticate(JsonObject authRequest) {
        String mechanism = Objects.requireNonNull(authRequest).getString("mechanism");
        this.log.debug("received authentication request [mechanism: {}]", (Object)mechanism);
        boolean isSupportedMechanism = Arrays.asList(this.getSupportedSaslMechanisms()).contains(mechanism);
        if (isSupportedMechanism && "PLAIN".equals(mechanism)) {
            byte[] saslResponse = authRequest.getBinary("sasl-response", new byte[0]);
            try {
                String[] fields = AuthenticationConstants.parseSaslResponse((byte[])saslResponse);
                String authzid = fields[0];
                String authcid = fields[1];
                String pwd = fields[2];
                this.log.debug("processing PLAIN authentication request [authzid: {}, authcid: {}, pwd: *****]", (Object)authzid, (Object)authcid);
                return this.verifyPlain(authzid, authcid, pwd);
            }
            catch (CredentialException e) {
                return Future.failedFuture((Throwable)new ClientErrorException(400, (Throwable)e));
            }
        }
        if (isSupportedMechanism && "EXTERNAL".equals(mechanism)) {
            String authzid = new String(authRequest.getBinary("sasl-response"), StandardCharsets.UTF_8);
            String subject = authRequest.getString("subject-dn");
            this.log.debug("processing EXTERNAL authentication request [Subject DN: {}]", (Object)subject);
            return this.verifyExternal(authzid, subject);
        }
        return Future.failedFuture((Throwable)new ClientErrorException(400, "unsupported SASL mechanism"));
    }

    public abstract Future<HonoUser> verifyPlain(String var1, String var2, String var3);

    public abstract Future<HonoUser> verifyExternal(String var1, String var2);

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

