/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="We cannot validate the certificate chain when the TLS connection gets established because we need to\ndynamically look up the trust anchors configured for the tenant that the client (device) belongs to.\nTherefore, the validation of the chain of trust is done at the application level, i.e. during connection\nestablishment and/or request processing instead.\n")
public final class ValidityOnlyTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ValidityOnlyTrustManagerFactory.class);
    private static final X509Certificate[] EMPTY_CERTS = new X509Certificate[0];
    private final TrustManager tm = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EMPTY_CERTS;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (chain == null) {
                throw new NullPointerException("certificate chain must not be null");
            }
            if (chain.length < 1) {
                throw new IllegalArgumentException("certificate chain must not be empty");
            }
            X509Certificate deviceCert = chain[0];
            Instant notBefore = deviceCert.getNotBefore().toInstant();
            Instant notAfter = deviceCert.getNotAfter().toInstant();
            Instant now = Instant.now();
            if (now.isBefore(notBefore)) {
                throw new CertificateNotYetValidException();
            }
            if (now.isAfter(notAfter)) {
                throw new CertificateExpiredException();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("accepting client certificate [not before: {}, not after: {}, subject DN: {}, issuer DN: {}]", new Object[]{notBefore, notAfter, deviceCert.getSubjectX500Principal().getName("RFC2253"), deviceCert.getIssuerX500Principal().getName("RFC2253")});
            }
        }
    };

    protected void engineInit(KeyStore keyStore) throws Exception {
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
    }

    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.tm};
    }
}

