/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.json.JsonObject;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.service.auth.EncodedPassword;
import org.eclipse.hono.service.auth.HonoPasswordEncoder;
import org.eclipse.hono.service.auth.MessageDigestPasswordEncoder;
import org.eclipse.hono.util.CredentialsObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public class SpringBasedHonoPasswordEncoder
implements HonoPasswordEncoder {
    public static final int DEFAULT_BCRYPT_STRENGTH = 10;
    private static final Logger LOG = LoggerFactory.getLogger(SpringBasedHonoPasswordEncoder.class);
    private final Map<String, PasswordEncoder> encoders = new HashMap<String, PasswordEncoder>();
    private final PasswordEncoder encoderForEncode;
    private final String idForEncode;
    private final SecureRandom secureRandom;

    public SpringBasedHonoPasswordEncoder() {
        this(SpringBasedHonoPasswordEncoder.newSecureRandom(), 10);
    }

    public SpringBasedHonoPasswordEncoder(int bcryptStrength) {
        this(SpringBasedHonoPasswordEncoder.newSecureRandom(), bcryptStrength);
    }

    public SpringBasedHonoPasswordEncoder(SecureRandom rng, int bcryptStrength) {
        this.secureRandom = Objects.requireNonNull(rng);
        this.encoderForEncode = new BCryptPasswordEncoder(bcryptStrength, this.secureRandom);
        this.idForEncode = "bcrypt";
        this.encoders.put(this.idForEncode, this.encoderForEncode);
        this.encoders.put("sha-256", new MessageDigestPasswordEncoder("sha-256", this.secureRandom));
        this.encoders.put("sha-512", new MessageDigestPasswordEncoder("sha-512", this.secureRandom));
        LOG.info("using BCrypt [strength: {}] with PRNG [{}] for encoding clear text passwords", (Object)bcryptStrength, (Object)rng.getAlgorithm());
    }

    @Override
    public JsonObject encode(String rawPassword) {
        EncodedPassword encodedPwd = new EncodedPassword(this.encoderForEncode.encode((CharSequence)rawPassword));
        return CredentialsObject.hashedPasswordSecretForPasswordHash((String)encodedPwd.password, (String)this.idForEncode, null, null, (byte[])encodedPwd.salt);
    }

    @Override
    public boolean matches(String rawPassword, JsonObject credentialsOnRecord) {
        try {
            EncodedPassword encodedPassword = EncodedPassword.fromHonoSecret(credentialsOnRecord);
            PasswordEncoder encoder = Optional.ofNullable(this.encoders.get(encodedPassword.hashFunction)).orElse(this.encoderForEncode);
            return encoder.matches((CharSequence)rawPassword, encodedPassword.format());
        }
        catch (IllegalArgumentException e) {
            LOG.debug("error matching password", (Throwable)e);
            return false;
        }
    }

    private static SecureRandom newSecureRandom() {
        try {
            return SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException e) {
            return new SecureRandom();
        }
    }
}

