/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BCryptHelper {
    private static final Pattern BCRYPT_PATTERN = Pattern.compile("\\A\\$([^$]{2})\\$(\\d{1,2})\\$[./0-9A-Za-z]{53}");

    private BCryptHelper() {
    }

    public static int getCostFactor(String bcryptedPassword) {
        Matcher matcher = BCRYPT_PATTERN.matcher(bcryptedPassword);
        if (matcher.matches()) {
            if ("2a".equals(matcher.group(1))) {
                return Integer.valueOf(matcher.group(2));
            }
            throw new IllegalArgumentException("invalid BCrypt version, supports 2a only");
        }
        throw new IllegalArgumentException("not a BCrypt hash");
    }
}

