/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.delegating.quarkus;

import io.quarkus.arc.properties.IfBuildProperty;
import io.vertx.core.Vertx;
import io.vertx.proton.sasl.ProtonSaslAuthenticatorFactory;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.client.amqp.connection.ConnectionFactory;
import org.eclipse.hono.service.auth.AuthTokenHelper;
import org.eclipse.hono.service.auth.AuthTokenHelperImpl;
import org.eclipse.hono.service.auth.AuthenticationService;
import org.eclipse.hono.service.auth.HonoSaslAuthenticatorFactory;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClientConfigProperties;
import org.eclipse.hono.service.auth.delegating.DelegatingAuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@IfBuildProperty(name="hono.auth", stringValue="delegating")
public class DelegatingAuthenticationServiceProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingAuthenticationServiceProducer.class);

    @Produces
    AuthenticationService delegatingAuthenticationService(Vertx vertx, AuthenticationServerClientConfigProperties authServerClientConfig) {
        LOG.info("creating {} instance", (Object)DelegatingAuthenticationService.class.getName());
        DelegatingAuthenticationService service = new DelegatingAuthenticationService();
        service.setConfig((Object)authServerClientConfig);
        service.setConnectionFactory(ConnectionFactory.newConnectionFactory((Vertx)vertx, (ClientConfigProperties)authServerClientConfig));
        return service;
    }

    @Produces
    ProtonSaslAuthenticatorFactory honoSaslAuthenticatorFactory(Vertx vertx, AuthenticationServerClientConfigProperties authServerClientConfig, AuthenticationService authenticationService) {
        AuthTokenHelper authTokenValidator = AuthTokenHelperImpl.forValidating(vertx, authServerClientConfig.getValidation());
        return new HonoSaslAuthenticatorFactory(vertx, authTokenValidator, authenticationService);
    }
}

