/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.delegating;

import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.config.SignatureSupportingConfigProperties;
import org.eclipse.hono.service.auth.AbstractHonoAuthenticationService;
import org.eclipse.hono.service.auth.delegating.AuthenticationServerClientOptions;

public class AuthenticationServerClientConfigProperties
extends ClientConfigProperties {
    private SignatureSupportingConfigProperties validation = new SignatureSupportingConfigProperties();
    private List<String> supportedSaslMechanisms = List.of("EXTERNAL", "PLAIN");

    public AuthenticationServerClientConfigProperties() {
    }

    public AuthenticationServerClientConfigProperties(AuthenticationServerClientOptions options) {
        super(options.clientOptions());
        this.setSupportedSaslMechanisms(List.copyOf(options.supportedSaslMechanisms()));
        this.validation = new SignatureSupportingConfigProperties(options.validation());
    }

    public final void setValidation(SignatureSupportingConfigProperties props) {
        this.validation = Objects.requireNonNull(props);
    }

    public final SignatureSupportingConfigProperties getValidation() {
        return this.validation;
    }

    public final List<String> getSupportedSaslMechanisms() {
        return this.supportedSaslMechanisms;
    }

    public final void setSupportedSaslMechanisms(List<String> supportedSaslMechanisms) {
        if (Objects.requireNonNull(supportedSaslMechanisms).stream().noneMatch(AbstractHonoAuthenticationService::isCompatibleSaslMechanism)) {
            throw new IllegalArgumentException("invalid list of SASL mechanisms");
        }
        this.supportedSaslMechanisms = supportedSaslMechanisms;
    }
}

