/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tracing;

import java.net.URI;
import java.net.URISyntaxException;

public class UriNormalizationUtil {
    private UriNormalizationUtil() {
    }

    public static URI toURI(String path, boolean trailingSlash) {
        try {
            String tmpPath = path.replaceAll("//", "/");
            if (!trailingSlash && tmpPath.endsWith("/")) {
                tmpPath = tmpPath.substring(0, tmpPath.length() - 1);
            }
            if (tmpPath.contains("..") || tmpPath.contains("%")) {
                throw new IllegalArgumentException("Specified path can not contain '..' or '%'. Path was " + tmpPath);
            }
            URI uri = new URI(tmpPath).normalize();
            if (uri.getPath().equals("")) {
                return trailingSlash ? new URI("/") : new URI("");
            }
            if (trailingSlash && !tmpPath.endsWith("/")) {
                uri = new URI(uri.getPath() + "/");
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Specified path is an invalid URI. Path was " + path, e);
        }
    }

    public static URI normalizeWithBase(URI base, String segment, boolean trailingSlash) {
        if (segment == null || segment.trim().isEmpty()) {
            if ("/".equals(base.getPath())) {
                return base;
            }
            return UriNormalizationUtil.toURI(base.getPath(), trailingSlash);
        }
        URI segmentUri = UriNormalizationUtil.toURI(segment, trailingSlash);
        URI resolvedUri = base.resolve(segmentUri);
        return resolvedUri;
    }
}

