/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.vertx.core.Vertx;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import io.vertx.proton.sasl.ProtonSaslAuthenticatorFactory;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.hono.service.auth.AuthTokenHelper;
import org.eclipse.hono.service.auth.AuthenticationService;
import org.eclipse.hono.service.auth.EventBusAuthenticationService;
import org.eclipse.hono.service.auth.HonoSaslAuthenticator;

public final class HonoSaslAuthenticatorFactory
implements ProtonSaslAuthenticatorFactory {
    private final AuthenticationService authenticationService;
    private final Consumer<AuthenticationService.AuthenticationAttemptOutcome> authenticationAttemptMeter;

    public HonoSaslAuthenticatorFactory(Vertx vertx, AuthTokenHelper validator, AuthenticationService actualAuthenticationService) {
        this(new EventBusAuthenticationService(vertx, validator, actualAuthenticationService.getSupportedSaslMechanisms()));
    }

    public HonoSaslAuthenticatorFactory(Vertx vertx, AuthTokenHelper validator) {
        this(new EventBusAuthenticationService(vertx, validator));
    }

    public HonoSaslAuthenticatorFactory(AuthenticationService authService) {
        this(authService, null);
    }

    public HonoSaslAuthenticatorFactory(AuthenticationService authService, Consumer<AuthenticationService.AuthenticationAttemptOutcome> authenticationAttemptMeter) {
        this.authenticationService = Objects.requireNonNull(authService);
        this.authenticationAttemptMeter = authenticationAttemptMeter;
    }

    public ProtonSaslAuthenticator create() {
        return new HonoSaslAuthenticator(this.authenticationService, this.authenticationAttemptMeter);
    }
}

