/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.opentracing.Span;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.eclipse.hono.service.tenant.TenantObjectWithAuthId;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.TracingSamplingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TenantTraceSamplingHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TenantTraceSamplingHelper.class);

    private TenantTraceSamplingHelper() {
    }

    public static OptionalInt getTraceSamplingPriority(TenantObjectWithAuthId tenantObjectWithAuthId) {
        Objects.requireNonNull(tenantObjectWithAuthId);
        return Optional.ofNullable(TenantTraceSamplingHelper.getSamplingMode(tenantObjectWithAuthId)).map(mode -> TenantTraceSamplingHelper.getSamplingPriority(mode)).orElse(OptionalInt.empty());
    }

    public static OptionalInt applyTraceSamplingPriority(TenantObjectWithAuthId tenantObjectWithAuthId, Span span) {
        Objects.requireNonNull(tenantObjectWithAuthId);
        Objects.requireNonNull(span);
        return Optional.ofNullable(TenantTraceSamplingHelper.getSamplingMode(tenantObjectWithAuthId)).map(mode -> TenantTraceSamplingHelper.getSamplingPriority(mode)).map(samplingPriority -> {
            samplingPriority.ifPresent(prio -> {
                LOG.trace("setting trace sampling prio to {} for tenant [{}], auth-id [{}]", new Object[]{prio, tenantObjectWithAuthId.getTenantObject().getTenantId(), tenantObjectWithAuthId.getAuthId()});
                TracingHelper.setTraceSamplingPriority((Span)span, (int)prio);
            });
            return samplingPriority;
        }).orElse(OptionalInt.empty());
    }

    @JsonIgnore
    private static TracingSamplingMode getSamplingMode(TenantObjectWithAuthId tenantAndAuthId) {
        return Optional.ofNullable(tenantAndAuthId.getTenantObject().getTracingConfig()).map(config -> config.getSamplingMode(tenantAndAuthId.getAuthId())).orElse(null);
    }

    private static OptionalInt getSamplingPriority(TracingSamplingMode mode) {
        switch (mode) {
            case ALL: {
                return OptionalInt.of(1);
            }
            case NONE: {
                return OptionalInt.of(0);
            }
        }
        return OptionalInt.empty();
    }
}

