/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import io.opentracing.SpanContext;
import io.vertx.core.Future;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.client.TenantClientFactory;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.tenant.TenantObjectWithAuthId;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseExecutionContextTenantAndAuthIdProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BaseExecutionContextTenantAndAuthIdProvider.class);
    protected final ProtocolAdapterProperties config;
    protected final TenantClientFactory tenantClientFactory;

    public BaseExecutionContextTenantAndAuthIdProvider(ProtocolAdapterProperties config, TenantClientFactory tenantClientFactory) {
        this.config = Objects.requireNonNull(config);
        this.tenantClientFactory = Objects.requireNonNull(tenantClientFactory);
    }

    protected final Future<TenantObjectWithAuthId> getFromClientCertificate(SSLSession sslSession, SpanContext spanContext) {
        Objects.requireNonNull(sslSession);
        X509Certificate deviceCert = this.getX509Cert(sslSession);
        if (deviceCert == null) {
            return Future.failedFuture((String)"no cert found");
        }
        return this.getFromClientCertificate(deviceCert, spanContext);
    }

    protected final Future<TenantObjectWithAuthId> getFromClientCertificate(X509Certificate certificate, SpanContext spanContext) {
        Objects.requireNonNull(certificate);
        X500Principal x500Principal = certificate.getIssuerX500Principal();
        String subjectDnAuthId = certificate.getSubjectX500Principal().getName();
        return this.get(x500Principal, subjectDnAuthId, spanContext);
    }

    private X509Certificate getX509Cert(SSLSession sslSession) {
        try {
            Certificate[] path = sslSession.getPeerCertificates();
            if (path.length > 0 && path[0] instanceof X509Certificate) {
                return (X509Certificate)path[0];
            }
        }
        catch (SSLPeerUnverifiedException e) {
            LOG.debug("certificate chain cannot be read: {}", (Object)e.getMessage());
        }
        return null;
    }

    protected final Future<TenantObjectWithAuthId> getFromUserName(String userName, SpanContext spanContext) {
        String authId;
        String tenantId;
        if (userName == null) {
            return Future.failedFuture((String)"user name not set");
        }
        if (this.config.isSingleTenant()) {
            tenantId = "DEFAULT_TENANT";
            authId = userName;
        } else {
            String[] userComponents = userName.split("@", 2);
            if (userComponents.length == 2) {
                tenantId = userComponents[1];
                authId = userComponents[0];
            } else {
                tenantId = null;
                authId = null;
            }
        }
        if (tenantId == null) {
            return Future.failedFuture((String)"unsupported user name format");
        }
        return this.get(tenantId, authId, spanContext);
    }

    private Future<TenantObjectWithAuthId> get(X500Principal x500Principal, String subjectDnAuthId, SpanContext spanContext) {
        return this.tenantClientFactory.getOrCreateTenantClient().compose(tenantClient -> tenantClient.get(x500Principal, spanContext)).map(tenantObject -> new TenantObjectWithAuthId((TenantObject)tenantObject, subjectDnAuthId));
    }

    protected final Future<TenantObjectWithAuthId> get(String tenantId, String authId, SpanContext spanContext) {
        if (tenantId == null) {
            return Future.failedFuture((String)"tenant id not set");
        }
        if (authId == null) {
            return Future.failedFuture((String)"auth id not set");
        }
        return this.tenantClientFactory.getOrCreateTenantClient().compose(tenantClient -> tenantClient.get(tenantId, spanContext)).map(tenantObject -> new TenantObjectWithAuthId((TenantObject)tenantObject, authId));
    }
}

