/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.monitoring;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.BiFunction;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.DownstreamSender;
import org.eclipse.hono.client.DownstreamSenderFactory;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;

public abstract class AbstractMessageSenderConnectionEventProducer
implements ConnectionEventProducer {
    private final BiFunction<DownstreamSenderFactory, String, Future<DownstreamSender>> messageSenderSource;

    protected AbstractMessageSenderConnectionEventProducer(BiFunction<DownstreamSenderFactory, String, Future<DownstreamSender>> messageSenderSource) {
        Objects.requireNonNull(messageSenderSource);
        this.messageSenderSource = messageSenderSource;
    }

    @Override
    public Future<?> connected(ConnectionEventProducer.Context context, String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data) {
        return this.sendNotificationEvent(context, authenticatedDevice, protocolAdapter, remoteId, "connected", data);
    }

    @Override
    public Future<?> disconnected(ConnectionEventProducer.Context context, String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data) {
        return this.sendNotificationEvent(context, authenticatedDevice, protocolAdapter, remoteId, "disconnected", data);
    }

    private Future<?> sendNotificationEvent(ConnectionEventProducer.Context context, Device authenticatedDevice, String protocolAdapter, String remoteId, String cause, JsonObject data) {
        if (authenticatedDevice == null) {
            return Future.succeededFuture();
        }
        return this.getOrCreateSender(context.getMessageSenderClient(), authenticatedDevice.getTenantId()).compose(sender -> {
            JsonObject payload = new JsonObject();
            payload.put("cause", cause);
            payload.put("remote-id", remoteId);
            payload.put("source", protocolAdapter);
            if (data != null) {
                payload.put("data", data);
            }
            return sender.send(authenticatedDevice.getDeviceId(), payload.encode().getBytes(StandardCharsets.UTF_8), "application/vnd.eclipse-hono-dc-notification+json");
        });
    }

    private Future<DownstreamSender> getOrCreateSender(DownstreamSenderFactory messageSenderClient, String tenant) {
        return this.messageSenderSource.apply(messageSenderClient, tenant);
    }
}

