/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.device;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceManagementService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.EventBusMessage;

@Deprecated(forRemoval=true)
public abstract class EventBusDeviceManagementAdapter
extends EventBusService
implements Verticle {
    private static final String SPAN_NAME_CREATE_DEVICE = "create Device from management API";
    private static final String SPAN_NAME_GET_DEVICE = "get Device from management API";
    private static final String SPAN_NAME_UPDATE_DEVICE = "update Device from management API";
    private static final String SPAN_NAME_REMOVE_DEVICE = "remove Device from management API";

    protected abstract DeviceManagementService getService();

    @Override
    protected String getEventBusAddress() {
        return "device.mgmt.in";
    }

    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage requestMessage) {
        Objects.requireNonNull(requestMessage);
        switch (requestMessage.getOperation()) {
            case "create": {
                return this.processCreateRequest(requestMessage);
            }
            case "get": {
                return this.processGetRequest(requestMessage);
            }
            case "update": {
                return this.processUpdateRequest(requestMessage);
            }
            case "delete": {
                return this.processDeleteRequest(requestMessage);
            }
        }
        return this.processCustomDeviceMessage(requestMessage);
    }

    protected Future<EventBusMessage> processCustomDeviceMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    private static Future<Device> deviceFromPayload(EventBusMessage request) {
        try {
            return Future.succeededFuture((Object)EventBusDeviceManagementAdapter.fromPayload(request));
        }
        catch (IllegalArgumentException e) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, (Throwable)e));
        }
    }

    static Device fromPayload(EventBusMessage request) throws ClientErrorException {
        return Optional.ofNullable(request.getJsonPayload()).map(json -> (Device)json.mapTo(Device.class)).orElseGet(Device::new);
    }

    private Future<EventBusMessage> processCreateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        Optional<String> deviceId = Optional.ofNullable(request.getDeviceId());
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_CREATE_DEVICE, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        TracingHelper.TAG_TENANT_ID.set(span, tenantId);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceId.orElse("unspecified"));
        Future resultFuture = EventBusDeviceManagementAdapter.deviceFromPayload(request).compose(device -> {
            this.log.debug("registering device [{}] for tenant [{}]", (Object)deviceId.orElse("<auto>"), (Object)tenantId);
            Promise result = Promise.promise();
            return this.getService().createDevice(tenantId, deviceId, (Device)device, span).map(res -> {
                String createdDeviceId = Optional.ofNullable((Id)res.getPayload()).map(Id::getId).orElse(null);
                return res.createResponse(request, JsonObject::mapFrom).setDeviceId(createdDeviceId);
            });
        });
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    private Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_GET_DEVICE, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        TracingHelper.TAG_TENANT_ID.set(span, tenantId);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
        if (tenantId == null || deviceId == null) {
            this.log.debug("missing tenant and/or device id");
            TracingHelper.logError((Span)span, (String)"missing tenant and/or device id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            this.log.debug("retrieving device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
            resultFuture = this.getService().readDevice(tenantId, deviceId, span).map(res -> res.createResponse(request, JsonObject::mapFrom).setDeviceId(deviceId));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        Optional<String> resourceVersion = Optional.ofNullable(request.getResourceVersion());
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_UPDATE_DEVICE, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        TracingHelper.TAG_TENANT_ID.set(span, tenantId);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
        if (tenantId == null || deviceId == null) {
            this.log.debug("missing tenant and/or device id");
            TracingHelper.logError((Span)span, (String)"missing tenant and/or device id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            resultFuture = EventBusDeviceManagementAdapter.deviceFromPayload(request).compose(device -> {
                this.log.debug("updating registration information for device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
                return this.getService().updateDevice(tenantId, deviceId, (Device)device, resourceVersion, span).map(res -> res.createResponse(request, JsonObject::mapFrom).setDeviceId(deviceId));
            });
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    private Future<EventBusMessage> processDeleteRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        Optional<String> resourceVersion = Optional.ofNullable(request.getResourceVersion());
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_REMOVE_DEVICE, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        TracingHelper.TAG_TENANT_ID.set(span, tenantId);
        TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
        if (tenantId == null || deviceId == null) {
            this.log.debug("missing tenant and/or device id");
            TracingHelper.logError((Span)span, (String)"missing tenant and/or device id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            this.log.debug("deleting device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
            resultFuture = this.getService().deleteDevice(tenantId, deviceId, resourceVersion, span).map(res -> res.createResponse(request, id -> null).setDeviceId(deviceId));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }
}

