/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.device;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Device {
    private Boolean enabled;
    @JsonProperty(value="ext")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> extensions = new HashMap<String, Object>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Object> defaults = new HashMap<String, Object>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> via = new LinkedList<String>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> viaGroups = new LinkedList<String>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> memberOf = new LinkedList<String>();

    public Device() {
    }

    public Device(Device other) {
        Objects.requireNonNull(other);
        this.enabled = other.enabled;
        if (other.extensions != null) {
            this.extensions = new HashMap<String, Object>(other.extensions);
        }
        if (other.defaults != null) {
            this.defaults = new HashMap<String, Object>(other.defaults);
        }
        if (other.via != null) {
            this.via = new ArrayList<String>(other.via);
        }
        if (other.viaGroups != null) {
            this.viaGroups = new ArrayList<String>(other.viaGroups);
        }
        if (other.memberOf != null) {
            this.memberOf = new ArrayList<String>(other.memberOf);
        }
    }

    public Device setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Device setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public Device putExtension(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, value);
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public Device setDefaults(Map<String, Object> defaults) {
        this.defaults = defaults;
        return this;
    }

    public Map<String, Object> getDefaults() {
        return this.defaults;
    }

    public List<String> getVia() {
        return this.via;
    }

    public Device setVia(List<String> via) {
        if (this.memberOf != null && !this.memberOf.isEmpty()) {
            throw new IllegalArgumentException("Trying to set the 'via' property while the 'memberOf' property is already set though both properties must not be set at the same time.");
        }
        this.via = via;
        return this;
    }

    public List<String> getViaGroups() {
        return this.viaGroups;
    }

    public Device setViaGroups(List<String> viaGroups) {
        if (this.memberOf != null && !this.memberOf.isEmpty()) {
            throw new IllegalArgumentException("Trying to set the 'viaGroups' property while the 'memberOf' property is already set though both properties must not be set at the same time.");
        }
        this.viaGroups = viaGroups;
        return this;
    }

    public List<String> getMemberOf() {
        return this.memberOf;
    }

    public Device setMemberOf(List<String> memberOf) {
        if (this.via != null && !this.via.isEmpty()) {
            throw new IllegalArgumentException("Trying to set the 'memberOf' property while the 'via' property is already set though both properties must not be set at the same time.");
        }
        if (this.viaGroups != null && !this.viaGroups.isEmpty()) {
            throw new IllegalArgumentException("Trying to set the 'memberOf' property while the 'viaGroups' property is already set though both properties must not be set at the same time.");
        }
        this.memberOf = memberOf;
        return this;
    }
}

