/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management;

import com.google.common.base.MoreObjects;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.EventBusMessage;

public final class OperationResult<T>
extends Result<T> {
    private final Optional<String> resourceVersion;

    protected OperationResult(int status, T payload, Optional<CacheDirective> cacheDirective, Optional<String> resourceVersion) {
        super(status, payload, cacheDirective);
        this.resourceVersion = resourceVersion;
    }

    public Optional<String> getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public EventBusMessage createResponse(EventBusMessage request, Function<T, JsonObject> payloadMapper) {
        EventBusMessage response = super.createResponse(request, payloadMapper);
        this.resourceVersion.ifPresent(arg_0 -> ((EventBusMessage)response).setResourceVersion(arg_0));
        return response;
    }

    public static <T> OperationResult<T> ok(int status, T payload, Optional<CacheDirective> directive, Optional<String> resourceVersion) {
        Objects.requireNonNull(resourceVersion);
        return new OperationResult<T>(status, payload, directive, resourceVersion);
    }

    public static <T> OperationResult<T> empty(int status) {
        return new OperationResult<Object>(status, null, Optional.empty(), Optional.empty());
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("resourceVersion", this.resourceVersion);
    }
}

