/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.limiting;

import org.eclipse.hono.service.limiting.ConnectionLimitStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryBasedConnectionLimitStrategy
implements ConnectionLimitStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryBasedConnectionLimitStrategy.class);
    private final long memoryRequiredToStart;
    private final long memoryRequiredPerConnection;
    private final long maxMemory;

    public MemoryBasedConnectionLimitStrategy(long memoryRequiredToStart, long memoryRequiredPerConnection) {
        this(memoryRequiredToStart, memoryRequiredPerConnection, Runtime.getRuntime().maxMemory());
    }

    MemoryBasedConnectionLimitStrategy(long memoryRequiredToStart, long memoryRequiredPerConnection, long maxMemory) {
        this.memoryRequiredToStart = memoryRequiredToStart;
        this.memoryRequiredPerConnection = memoryRequiredPerConnection;
        this.maxMemory = maxMemory;
    }

    @Override
    public int getRecommendedLimit() {
        long recommendedLimit = (this.maxMemory - this.memoryRequiredToStart) / this.memoryRequiredPerConnection;
        if (recommendedLimit <= 0L) {
            LOG.warn("Not enough memory. It is recommended to provide more than {} MB (currently {}).", (Object)((this.memoryRequiredToStart + this.memoryRequiredPerConnection) / 1000000L), (Object)this.getResourcesDescription());
            return 0;
        }
        if (recommendedLimit > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)recommendedLimit;
    }

    @Override
    public String getResourcesDescription() {
        return "max. available memory: " + this.maxMemory / 1000000L + "MB";
    }
}

