/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.service.http.HttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.service.http.TracingHandler;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.Strings;

@Deprecated(forRemoval=true)
public abstract class AbstractEventBusHttpEndpoint<T extends ServiceConfigProperties>
extends AbstractHttpEndpoint<T>
implements HttpEndpoint {
    public AbstractEventBusHttpEndpoint(Vertx vertx) {
        super(vertx);
    }

    protected abstract String getEventBusAddress();

    protected final BiConsumer<Integer, EventBusMessage> getDefaultResponseHandler(RoutingContext ctx) {
        return this.getDefaultResponseHandler(ctx, (int status) -> false, (Handler<HttpServerResponse>)((Handler)null));
    }

    protected final BiConsumer<Integer, EventBusMessage> getDefaultResponseHandler(RoutingContext ctx, IntPredicate successfulOutcomeFilter, Handler<HttpServerResponse> customHandler) {
        Objects.requireNonNull(successfulOutcomeFilter);
        HttpServerResponse response = ctx.response();
        return (status, responseMessage) -> {
            response.setStatusCode(status.intValue());
            if (status >= 400) {
                HttpUtils.setResponseBody(response, responseMessage.getJsonPayload());
            } else if (successfulOutcomeFilter.test((int)status)) {
                HttpUtils.setResponseBody(response, responseMessage.getJsonPayload());
                if (customHandler != null) {
                    customHandler.handle((Object)response);
                }
            }
            response.end();
        };
    }

    protected final BiConsumer<Integer, EventBusMessage> getDefaultResponseHandler(RoutingContext ctx, IntPredicate successfulOutcomeFilter, BiConsumer<HttpServerResponse, EventBusMessage> customHandler) {
        Objects.requireNonNull(successfulOutcomeFilter);
        HttpServerResponse response = ctx.response();
        return (status, result) -> {
            response.setStatusCode(status.intValue());
            if (status >= 400) {
                HttpUtils.setResponseBody(response, result.getJsonPayload());
            } else if (successfulOutcomeFilter.test((int)status)) {
                if (customHandler != null) {
                    customHandler.accept(response, (EventBusMessage)result);
                }
                HttpUtils.setResponseBody(response, result.getJsonPayload());
            }
            response.end();
        };
    }

    protected final void sendAction(RoutingContext ctx, JsonObject requestMsg, BiConsumer<Integer, EventBusMessage> responseHandler) {
        DeliveryOptions options = this.createEventBusMessageDeliveryOptions(this.config.getSendTimeOut(), TracingHandler.serverSpanContext(ctx));
        this.vertx.eventBus().request(this.getEventBusAddress(), (Object)requestMsg, options, invocation -> {
            if (invocation.failed()) {
                HttpUtils.serviceUnavailable(ctx, 2);
            } else {
                EventBusMessage response = EventBusMessage.fromJson((JsonObject)((JsonObject)((Message)invocation.result()).body()));
                Integer status = response.getStatus();
                String version = response.getResourceVersion();
                if (!Strings.isNullOrEmpty((Object)version)) {
                    ctx.response().putHeader(HttpHeaders.ETAG, (CharSequence)version);
                }
                responseHandler.accept(status, response);
            }
        });
    }
}

