/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.cache;

import java.util.Objects;
import org.eclipse.hono.cache.CacheProvider;
import org.eclipse.hono.cache.ExpiringValueCache;
import org.eclipse.hono.service.cache.SpringBasedExpiringValueCache;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class SpringCacheProvider
implements CacheProvider {
    private final CacheManager manager;

    public SpringCacheProvider(CacheManager manager) {
        Objects.requireNonNull(manager);
        this.manager = manager;
    }

    public <K, V> ExpiringValueCache<K, V> getCache(String cacheName) {
        Objects.requireNonNull(cacheName);
        Cache cache = this.manager.getCache(cacheName);
        if (cache == null) {
            return null;
        }
        return new SpringBasedExpiringValueCache(cache);
    }
}

