/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.CredentialsClientFactory;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.auth.device.CredentialsApiAuthProvider;
import org.eclipse.hono.service.auth.device.SubjectDnCredentials;
import org.eclipse.hono.util.CredentialsObject;
import org.springframework.beans.factory.annotation.Autowired;

public class X509AuthProvider
extends CredentialsApiAuthProvider<SubjectDnCredentials> {
    private final ServiceConfigProperties config;

    @Autowired
    public X509AuthProvider(CredentialsClientFactory credentialsClientFactory, ServiceConfigProperties config, Tracer tracer) {
        super(credentialsClientFactory, tracer);
        this.config = Objects.requireNonNull(config);
    }

    @Override
    protected SubjectDnCredentials getCredentials(JsonObject authInfo) {
        Objects.requireNonNull(authInfo);
        try {
            String tenantId = Optional.ofNullable(authInfo.getString("tenant-id")).orElseGet(() -> {
                if (this.config.isSingleTenant()) {
                    return "DEFAULT_TENANT";
                }
                return null;
            });
            String subjectDn = authInfo.getString("subject-dn");
            if (tenantId == null || subjectDn == null) {
                return null;
            }
            JsonObject clientContext = authInfo.copy();
            clientContext.remove("tenant-id");
            clientContext.remove("subject-dn");
            return SubjectDnCredentials.create(tenantId, subjectDn, clientContext);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            this.log.warn("Reading authInfo failed", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Future<Device> doValidateCredentials(SubjectDnCredentials deviceCredentials, CredentialsObject credentialsOnRecord) {
        return Future.succeededFuture((Object)new Device(deviceCredentials.getTenantId(), credentialsOnRecord.getDeviceId()));
    }
}

