/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.tenant.TenantService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.TenantConstants;

@Deprecated
public abstract class EventBusTenantAdapter
extends EventBusService
implements Verticle {
    private static final String SPAN_NAME_GET_TENANT = "get Tenant";
    private static final String TAG_SUBJECT_DN_NAME = "subject_dn_name";

    protected abstract TenantService getService();

    @Override
    protected final String getEventBusAddress() {
        return "tenant.in";
    }

    @Override
    public Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        switch (TenantConstants.TenantAction.from((String)request.getOperation())) {
            case get: {
                return this.processGetRequest(request);
            }
        }
        return this.processCustomTenantMessage(request);
    }

    Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        Future<EventBusMessage> resultFuture;
        String tenantId = request.getTenant();
        JsonObject payload = request.getJsonPayload();
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_GET_TENANT, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        if (tenantId == null && payload == null) {
            TracingHelper.logError((Span)span, (String)"request does not contain any query parameters");
            this.log.debug("request does not contain any query parameters");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else if (tenantId != null) {
            this.log.debug("retrieving tenant [{}] using deprecated variant of get tenant request", (Object)tenantId);
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            span.log("using deprecated variant of get tenant request");
            resultFuture = this.processGetByIdRequest(request, tenantId, span);
        } else {
            String tenantIdFromPayload = EventBusTenantAdapter.getTypesafeValueForField(String.class, payload, "tenant-id");
            String subjectDn = EventBusTenantAdapter.getTypesafeValueForField(String.class, payload, "subject-dn");
            if (tenantIdFromPayload == null && subjectDn == null) {
                TracingHelper.logError((Span)span, (String)"request does not contain any query parameters");
                this.log.debug("payload does not contain any query parameters");
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
            } else if (tenantIdFromPayload != null) {
                this.log.debug("retrieving tenant [id: {}]", (Object)tenantIdFromPayload);
                TracingHelper.TAG_TENANT_ID.set(span, tenantIdFromPayload);
                resultFuture = this.processGetByIdRequest(request, tenantIdFromPayload, span);
            } else {
                span.setTag(TAG_SUBJECT_DN_NAME, subjectDn);
                resultFuture = this.processGetByCaRequest(request, subjectDn, span);
            }
        }
        return this.finishSpanOnFutureCompletion(span, resultFuture);
    }

    private Future<EventBusMessage> processGetByIdRequest(EventBusMessage request, String tenantId, Span span) {
        return this.getService().get(tenantId, span).map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setTenant(tenantId).setCacheDirective(tr.getCacheDirective()));
    }

    private Future<EventBusMessage> processGetByCaRequest(EventBusMessage request, String subjectDn, Span span) {
        try {
            X500Principal dn = new X500Principal(subjectDn);
            this.log.debug("retrieving tenant [subject DN: {}]", (Object)subjectDn);
            return this.getService().get(dn, span).map(tr -> {
                EventBusMessage response = request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective());
                if (tr.isOk() && tr.getPayload() != null) {
                    String tenantId = EventBusTenantAdapter.getTypesafeValueForField(String.class, (JsonObject)tr.getPayload(), "tenant-id");
                    span.setTag("tenant_id", tenantId);
                    response.setTenant(tenantId);
                }
                return response;
            });
        }
        catch (IllegalArgumentException e) {
            TracingHelper.logError((Span)span, (String)("illegal subject DN provided by client: " + subjectDn));
            this.log.debug("cannot parse subject DN [{}] provided by client", (Object)subjectDn);
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
    }

    protected Future<EventBusMessage> processCustomTenantMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }
}

