/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AbstractRequestResponseEndpoint;
import org.eclipse.hono.service.tenant.TenantMessageFilter;
import org.eclipse.hono.service.tenant.TenantService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.RequestResponseResult;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.TenantConstants;

public abstract class AbstractTenantAmqpEndpoint
extends AbstractRequestResponseEndpoint<ServiceConfigProperties> {
    private static final String SPAN_NAME_GET_TENANT = "get Tenant";
    private static final String TAG_SUBJECT_DN_NAME = "subject_dn_name";

    public AbstractTenantAmqpEndpoint(Vertx vertx) {
        super(vertx);
    }

    @Override
    public final String getName() {
        return "tenant";
    }

    protected abstract TenantService getService();

    @Override
    protected Future<Message> handleRequestMessage(Message requestMessage, ResourceIdentifier targetAddress) {
        Objects.requireNonNull(requestMessage);
        switch (TenantConstants.TenantAction.from((String)requestMessage.getSubject())) {
            case get: {
                return this.processGetRequest(requestMessage);
            }
        }
        return this.processCustomTenantMessage(requestMessage);
    }

    private Future<Message> processGetRequest(Message request) {
        Future<Message> resultFuture;
        JsonObject payload;
        String tenantId = MessageHelper.getTenantId((Message)request);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHelper.extractSpanContext((Tracer)this.tracer, (Message)request), (String)SPAN_NAME_GET_TENANT, (String)this.getClass().getSimpleName()).start();
        try {
            payload = MessageHelper.getJsonPayload((Message)request);
        }
        catch (DecodeException e) {
            this.logger.debug("failed to decode AMQP request message", (Throwable)e);
            return this.finishSpanOnFutureCompletion(span, (Future<Message>)Future.failedFuture((Throwable)new ClientErrorException(400, "request message body contains malformed JSON")));
        }
        if (tenantId == null && payload == null) {
            TracingHelper.logError((Span)span, (String)"request does not contain any query parameters");
            this.log.debug("request does not contain any query parameters");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else if (tenantId != null) {
            this.log.debug("retrieving tenant [{}] using deprecated variant of get tenant request", (Object)tenantId);
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            span.log("using deprecated variant of get tenant request");
            resultFuture = this.processGetByIdRequest(request, tenantId, span);
        } else {
            String tenantIdFromPayload = AbstractTenantAmqpEndpoint.getTypesafeValueForField(String.class, payload, "tenant-id");
            String subjectDn = AbstractTenantAmqpEndpoint.getTypesafeValueForField(String.class, payload, "subject-dn");
            if (tenantIdFromPayload == null && subjectDn == null) {
                TracingHelper.logError((Span)span, (String)"request does not contain any query parameters");
                this.log.debug("payload does not contain any query parameters");
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
            } else if (tenantIdFromPayload != null) {
                this.log.debug("retrieving tenant [id: {}]", (Object)tenantIdFromPayload);
                TracingHelper.TAG_TENANT_ID.set(span, tenantIdFromPayload);
                resultFuture = this.processGetByIdRequest(request, tenantIdFromPayload, span);
            } else {
                span.setTag(TAG_SUBJECT_DN_NAME, subjectDn);
                resultFuture = this.processGetByCaRequest(request, subjectDn, span);
            }
        }
        return this.finishSpanOnFutureCompletion(span, resultFuture);
    }

    private Future<Message> processGetByIdRequest(Message request, String tenantId, Span span) {
        return this.getService().get(tenantId, span).map(tr -> TenantConstants.getAmqpReply((String)"tenant", (String)tenantId, (Message)request, (RequestResponseResult)tr));
    }

    private Future<Message> processGetByCaRequest(Message request, String subjectDn, Span span) {
        try {
            X500Principal dn = new X500Principal(subjectDn);
            this.log.debug("retrieving tenant [subject DN: {}]", (Object)subjectDn);
            return this.getService().get(dn, span).map(tr -> {
                String tenantId = null;
                if (tr.isOk() && tr.getPayload() != null) {
                    tenantId = AbstractTenantAmqpEndpoint.getTypesafeValueForField(String.class, (JsonObject)tr.getPayload(), "tenant-id");
                    TracingHelper.TAG_TENANT_ID.set(span, tenantId);
                }
                return TenantConstants.getAmqpReply((String)"tenant", tenantId, (Message)request, (RequestResponseResult)tr);
            });
        }
        catch (IllegalArgumentException e) {
            TracingHelper.logError((Span)span, (String)("illegal subject DN provided by client: " + subjectDn));
            this.log.debug("cannot parse subject DN [{}] provided by client", (Object)subjectDn);
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
    }

    protected Future<Message> processCustomTenantMessage(Message request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getSubject());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    protected Future<Message> filterResponse(HonoUser clientPrincipal, Message request, Message response) {
        Objects.requireNonNull(clientPrincipal);
        Objects.requireNonNull(response);
        String tenantId = MessageHelper.getTenantId((Message)response);
        JsonObject payload = MessageHelper.getJsonPayload((Message)response);
        if (tenantId == null || payload == null) {
            return Future.succeededFuture((Object)response);
        }
        ResourceIdentifier resourceId = ResourceIdentifier.from((String)"tenant", (String)tenantId, null);
        return this.getAuthorizationService().isAuthorized(clientPrincipal, resourceId, request.getSubject()).map(isAuthorized -> {
            if (isAuthorized.booleanValue()) {
                return response;
            }
            throw new ClientErrorException(403);
        });
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, Message msg) {
        return TenantMessageFilter.verify(linkTarget, msg);
    }

    @Override
    protected boolean isValidReplyToAddress(ResourceIdentifier replyToAddress) {
        if (replyToAddress == null) {
            return false;
        }
        return replyToAddress.getResourcePath().length >= 2;
    }

    @Override
    protected Future<Boolean> isAuthorized(HonoUser clientPrincipal, ResourceIdentifier resource, Message request) {
        Objects.requireNonNull(request);
        String tenantId = MessageHelper.getTenantId((Message)request);
        if (tenantId == null) {
            return Future.succeededFuture((Object)Boolean.TRUE);
        }
        ResourceIdentifier specificTenantAddress = ResourceIdentifier.fromPath((String[])new String[]{resource.getEndpoint(), tenantId});
        return this.getAuthorizationService().isAuthorized(clientPrincipal, specificTenantAddress, request.getSubject());
    }
}

