/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.RegistrationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractRegistrationService
implements RegistrationService {
    public static final int DEFAULT_MAX_AGE_SECONDS = 300;
    private static final Logger log = LoggerFactory.getLogger(AbstractRegistrationService.class);

    protected abstract Future<RegistrationResult> getDevice(String var1, String var2, Span var3);

    protected abstract Future<JsonArray> resolveGroupMembers(String var1, JsonArray var2, Span var3);

    @Override
    public final Future<RegistrationResult> assertRegistration(String tenantId, String deviceId) {
        return this.assertRegistration(tenantId, deviceId, (Span)NoopSpan.INSTANCE);
    }

    @Override
    public Future<RegistrationResult> assertRegistration(String tenantId, String deviceId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(span);
        return this.getDevice(tenantId, deviceId, span).compose(result -> {
            if (this.isDeviceEnabled((RegistrationResult)result)) {
                JsonObject deviceData = ((JsonObject)result.getPayload()).getJsonObject("data");
                return this.createSuccessfulRegistrationResult(tenantId, deviceId, deviceData, span);
            }
            TracingHelper.logError((Span)span, (String)"device not enabled");
            return Future.succeededFuture((Object)RegistrationResult.from((int)404));
        });
    }

    @Override
    public final Future<RegistrationResult> assertRegistration(String tenantId, String deviceId, String gatewayId) {
        return this.assertRegistration(tenantId, deviceId, gatewayId, (Span)NoopSpan.INSTANCE);
    }

    @Override
    public Future<RegistrationResult> assertRegistration(String tenantId, String deviceId, String gatewayId, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(span);
        Future<RegistrationResult> deviceInfoTracker = this.getDevice(tenantId, deviceId, span);
        Future<RegistrationResult> gatewayInfoTracker = this.getDevice(tenantId, gatewayId, span);
        return CompositeFuture.all(deviceInfoTracker, gatewayInfoTracker).compose(ok -> {
            RegistrationResult deviceResult = (RegistrationResult)deviceInfoTracker.result();
            RegistrationResult gatewayResult = (RegistrationResult)gatewayInfoTracker.result();
            if (!this.isDeviceEnabled(deviceResult)) {
                log.debug("device not enabled");
                TracingHelper.logError((Span)span, (String)"device not enabled");
                return Future.succeededFuture((Object)RegistrationResult.from((int)404));
            }
            if (!this.isDeviceEnabled(gatewayResult)) {
                log.debug("gateway not enabled");
                TracingHelper.logError((Span)span, (String)"gateway not enabled");
                return Future.succeededFuture((Object)RegistrationResult.from((int)403));
            }
            JsonObject deviceData = ((JsonObject)deviceResult.getPayload()).getJsonObject("data", new JsonObject());
            JsonObject gatewayData = ((JsonObject)gatewayResult.getPayload()).getJsonObject("data", new JsonObject());
            if (log.isDebugEnabled()) {
                log.debug("Device data: {}", (Object)deviceData.encodePrettily());
                log.debug("Gateway data: {}", (Object)gatewayData.encodePrettily());
            }
            if (this.isGatewayAuthorized(gatewayId, gatewayData, deviceId, deviceData)) {
                return this.createSuccessfulRegistrationResult(tenantId, deviceId, deviceData, span);
            }
            log.debug("gateway not authorized");
            TracingHelper.logError((Span)span, (String)"gateway not authorized");
            return Future.succeededFuture((Object)RegistrationResult.from((int)403));
        });
    }

    protected boolean isGatewayAuthorized(String gatewayId, JsonObject gatewayData, String deviceId, JsonObject deviceData) {
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(gatewayData);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(deviceData);
        JsonArray via = this.convertObjectToJsonArray(deviceData.getValue("via"));
        JsonArray viaGroups = this.convertObjectToJsonArray(deviceData.getValue("viaGroups"));
        JsonArray gatewayDataMemberOf = this.convertObjectToJsonArray(gatewayData.getValue("memberOf"));
        return this.isGatewayInVia(gatewayId, via) || this.anyGatewayGroupInViaGroups(gatewayDataMemberOf, viaGroups);
    }

    private boolean isGatewayInVia(String gatewayId, JsonArray via) {
        return via.stream().filter(String.class::isInstance).anyMatch(gatewayId::equals);
    }

    private boolean anyGatewayGroupInViaGroups(JsonArray gatewayDataMemberOf, JsonArray viaGroups) {
        return viaGroups.stream().filter(String.class::isInstance).anyMatch(arg_0 -> ((JsonArray)gatewayDataMemberOf).contains(arg_0));
    }

    private JsonArray convertObjectToJsonArray(Object object) {
        JsonArray array;
        if (object instanceof JsonArray) {
            array = (JsonArray)object;
        } else {
            array = new JsonArray();
            if (object instanceof String) {
                array.add((String)object);
            }
        }
        return array;
    }

    private Future<RegistrationResult> createSuccessfulRegistrationResult(String tenantId, String deviceId, JsonObject deviceData, Span span) {
        return this.getAssertionPayload(tenantId, deviceId, deviceData, span).compose(payload -> Future.succeededFuture((Object)RegistrationResult.from((int)200, (JsonObject)payload, (CacheDirective)this.getRegistrationAssertionCacheDirective(deviceId, tenantId)))).recover(thr -> Future.succeededFuture((Object)RegistrationResult.from((int)ServiceInvocationException.extractStatusCode((Throwable)thr))));
    }

    protected final Future<JsonObject> getAssertionPayload(String tenantId, String deviceId, JsonObject registrationInfo) {
        return this.getAssertionPayload(tenantId, deviceId, registrationInfo, (Span)NoopSpan.INSTANCE);
    }

    protected final Future<JsonObject> getAssertionPayload(String tenantId, String deviceId, JsonObject registrationInfo, Span span) {
        return this.getSupportedGatewaysForDevice(tenantId, deviceId, registrationInfo, span).compose(via -> {
            JsonObject defaults;
            JsonObject result = new JsonObject().put("device-id", deviceId);
            if (!via.isEmpty()) {
                result.put("via", via);
            }
            if ((defaults = registrationInfo.getJsonObject("defaults")) != null) {
                result.put("defaults", defaults);
            }
            return Future.succeededFuture((Object)result);
        });
    }

    protected boolean isGatewaySupportedForDevice(String tenantId, String deviceId, JsonObject registrationInfo) {
        Object viaObj = registrationInfo.getValue("via");
        Object viaGroups = registrationInfo.getValue("viaGroups");
        return viaObj instanceof String && !((String)viaObj).isEmpty() || viaObj instanceof JsonArray && !((JsonArray)viaObj).isEmpty() || viaGroups instanceof String && !((String)viaGroups).isEmpty() || viaGroups instanceof JsonArray && !((JsonArray)viaGroups).isEmpty();
    }

    private boolean isDeviceEnabled(RegistrationResult registrationResult) {
        return registrationResult.isOk() && this.isDeviceEnabled(((JsonObject)registrationResult.getPayload()).getJsonObject("data"));
    }

    private boolean isDeviceEnabled(JsonObject registrationData) {
        return registrationData.getBoolean("enabled", Boolean.TRUE);
    }

    protected CacheDirective getRegistrationAssertionCacheDirective(String deviceId, String tenantId) {
        return CacheDirective.maxAgeDirective((long)300L);
    }

    protected Future<JsonArray> getSupportedGatewaysForDevice(String tenantId, String deviceId, JsonObject registrationInfo, Span span) {
        JsonArray via = this.convertObjectToJsonArray(registrationInfo.getValue("via"));
        JsonArray viaGroups = this.convertObjectToJsonArray(registrationInfo.getValue("viaGroups"));
        Future resultFuture = viaGroups.isEmpty() ? Future.succeededFuture((Object)via) : this.resolveGroupMembers(tenantId, viaGroups, span).compose(groupMembers -> {
            for (Object gateway : groupMembers) {
                if (via.contains(gateway)) continue;
                via.add(gateway);
            }
            return Future.succeededFuture((Object)via);
        }).recover(thr -> {
            log.debug("failed to resolve group members", thr);
            TracingHelper.logError((Span)span, (String)("failed to resolve group members: " + thr.getMessage()));
            return Future.failedFuture((Throwable)thr);
        });
        return resultFuture;
    }
}

