/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import io.vertx.core.Vertx;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeviceConnectionDurationTracker {
    protected final Logger log = LoggerFactory.getLogger(DeviceConnectionDurationTracker.class);
    private final AtomicLong noOfDeviceConnections;
    private final Consumer<Long> recorder;
    private final AtomicReference<Instant> startInstant = new AtomicReference();
    private final String tenantId;
    private final long timerId;
    private final Vertx vertx;

    private DeviceConnectionDurationTracker(String tenantId, Vertx vertx, long noOfDeviceConnections, Consumer<Long> recorder, long recordingIntervalInMs) {
        this.tenantId = tenantId;
        this.noOfDeviceConnections = new AtomicLong(noOfDeviceConnections);
        this.recorder = recorder;
        this.startInstant.set(Instant.now());
        this.vertx = vertx;
        this.timerId = this.vertx.setPeriodic(recordingIntervalInMs, id -> this.report());
        this.log.trace("Started a device connection duration tracker for the tenant [{}].", (Object)tenantId);
    }

    public DeviceConnectionDurationTracker updateNoOfDeviceConnections(long noOfDeviceConnections) {
        if (noOfDeviceConnections < 0L) {
            throw new IllegalArgumentException("number of device connections must be >= 0");
        }
        this.report();
        this.noOfDeviceConnections.set(noOfDeviceConnections);
        this.log.trace("Updated number of device connections for the tenant [{}] to [{}]", (Object)this.tenantId, (Object)noOfDeviceConnections);
        if (noOfDeviceConnections == 0L) {
            this.vertx.cancelTimer(this.timerId);
            this.log.trace("Stopped the device connection duration tracker for the tenant [{}].", (Object)this.tenantId);
            return null;
        }
        return this;
    }

    private void report() {
        long deviceConnectionDuration = this.noOfDeviceConnections.get() * Duration.between(this.startInstant.getAndSet(Instant.now()), Instant.now()).toMillis();
        this.recorder.accept(deviceConnectionDuration);
        this.log.trace("Reported device connection duration [tenant : {}, noOfDeviceConnections: {}, connectionDurationInMs: {}].", new Object[]{this.tenantId, this.noOfDeviceConnections.get(), deviceConnectionDuration});
    }

    public static final class Builder {
        private long noOfDeviceConnections;
        private Consumer<Long> recorder;
        private long recordingIntervalInMs;
        private String tenantId;
        private Vertx vertx;

        private Builder() {
        }

        public static Builder forTenant(String tenantId) {
            Builder builder = new Builder();
            builder.tenantId = Objects.requireNonNull(tenantId);
            return builder;
        }

        public Builder withRecordingInterval(long recordingIntervalInMs) {
            if (recordingIntervalInMs < 0L) {
                throw new IllegalArgumentException("recording interval must be >= 0");
            }
            this.recordingIntervalInMs = recordingIntervalInMs;
            return this;
        }

        public Builder withNumberOfDeviceConnections(long noOfDeviceConnections) {
            if (noOfDeviceConnections < 0L) {
                throw new IllegalArgumentException("number of device connections must be >= 0");
            }
            this.noOfDeviceConnections = noOfDeviceConnections;
            return this;
        }

        public Builder withVertx(Vertx vertx) {
            this.vertx = Objects.requireNonNull(vertx);
            return this;
        }

        public Builder recordUsing(Consumer<Long> consumer) {
            this.recorder = Objects.requireNonNull(consumer);
            return this;
        }

        public DeviceConnectionDurationTracker start() {
            return new DeviceConnectionDurationTracker(this.tenantId, this.vertx, this.noOfDeviceConnections, this.recorder, this.recordingIntervalInMs);
        }
    }
}

