/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.device;

import io.opentracing.Span;
import io.vertx.core.Future;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.credentials.X509CertificateCredential;
import org.eclipse.hono.service.management.credentials.X509CertificateSecret;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceBackend;

public interface AutoProvisioningEnabledDeviceBackend
extends DeviceBackend {
    default public Future<OperationResult<String>> provisionDevice(String tenantId, X509Certificate clientCertificate, Span span) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(clientCertificate);
        Objects.requireNonNull(span);
        span.log("Start auto-provisioning");
        String comment = "Auto-provisioned at " + Instant.now().toString();
        Device device = new Device().setEnabled(true).putExtension("comment", comment);
        return this.createDevice(tenantId, Optional.empty(), device, span).compose(r -> {
            if (r.isError()) {
                return Future.succeededFuture(OperationResult.ok(r.getStatus(), "Auto-provisioning failed: device could not be created", Optional.empty(), Optional.empty()));
            }
            X509CertificateCredential certCredential = new X509CertificateCredential().setSecrets(List.of(new X509CertificateSecret()));
            certCredential.setEnabled(true).setComment(comment).setAuthId(clientCertificate.getSubjectX500Principal().getName("RFC2253"));
            String deviceId = ((Id)r.getPayload()).getId();
            return this.updateCredentials(tenantId, deviceId, List.of(certCredential), Optional.empty(), span).compose(v -> {
                if (v.isError()) {
                    return this.deleteDevice(tenantId, deviceId, Optional.empty(), span).map(OperationResult.ok(v.getStatus(), "Auto-provisioning failed: credentials could not be set for device [" + deviceId + "]", Optional.empty(), Optional.empty()));
                }
                span.log("Auto-provisioning successful for device [" + deviceId + "]");
                return Future.succeededFuture(OperationResult.empty(201));
            });
        });
    }
}

