/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.credentials;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractEventBusHttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.util.EventBusMessage;
import org.springframework.beans.factory.annotation.Autowired;

@Deprecated(forRemoval=true)
public final class CredentialsManagementHttpEndpoint
extends AbstractEventBusHttpEndpoint<ServiceConfigProperties> {
    @Autowired
    public CredentialsManagementHttpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    protected String getEventBusAddress() {
        return "credentials.mgmt.in";
    }

    @Override
    public String getName() {
        return String.format("%s/%s", "v1", "credentials");
    }

    @Override
    public void addRoutes(Router router) {
        String pathWithTenantAndDeviceId = String.format("/%s/:%s/:%s", this.getName(), "tenant_id", "device_id");
        router.route(pathWithTenantAndDeviceId).handler((Handler)this.createCorsHandler(this.config.getCorsAllowedOrigin(), EnumSet.of(HttpMethod.GET, HttpMethod.PUT)));
        BodyHandler bodyHandler = BodyHandler.create();
        bodyHandler.setBodyLimit((long)this.config.getMaxPayloadSize());
        router.get(pathWithTenantAndDeviceId).handler(this::getCredentialsForDevice);
        router.put(pathWithTenantAndDeviceId).handler((Handler)bodyHandler);
        router.put(pathWithTenantAndDeviceId).handler(this::extractRequiredJsonArrayPayload);
        router.put(pathWithTenantAndDeviceId).handler(this::extractIfMatchVersionParam);
        router.put(pathWithTenantAndDeviceId).handler(this::updateCredentials);
    }

    private void updateCredentials(RoutingContext ctx) {
        JsonArray credentials = (JsonArray)ctx.get("KEY_REQUEST_BODY");
        String deviceId = this.getDeviceIdParam(ctx);
        String resourceVersion = (String)ctx.get("KEY_RESOURCE_VERSION");
        String tenantId = this.getTenantParam(ctx);
        this.logger.debug("updating credentials [tenant: {}, device-id: {}] - {}", new Object[]{tenantId, deviceId, credentials});
        JsonObject payload = new JsonObject();
        payload.put("credentials", credentials);
        JsonObject requestMsg = EventBusMessage.forOperation((String)"update").setTenant(tenantId).setDeviceId(deviceId).setResourceVersion(resourceVersion).setJsonPayload(payload).toJson();
        this.sendAction(ctx, requestMsg, this.getDefaultResponseHandler(ctx));
    }

    private void getCredentialsForDevice(RoutingContext ctx) {
        String tenantId = this.getTenantParam(ctx);
        String deviceId = this.getDeviceIdParam(ctx);
        this.logger.debug("getCredentialsForDevice [tenant: {}, device-id: {}]]", (Object)tenantId, (Object)deviceId);
        JsonObject requestMsg = EventBusMessage.forOperation((String)"get").setTenant(tenantId).setDeviceId(deviceId).toJson();
        this.sendAction(ctx, requestMsg, this.getCredentialsResponseHandler(ctx, status -> status == 200));
    }

    protected BiConsumer<Integer, EventBusMessage> getCredentialsResponseHandler(RoutingContext ctx, IntPredicate successfulOutcomeFilter) {
        Objects.requireNonNull(successfulOutcomeFilter);
        HttpServerResponse response = ctx.response();
        return (status, responseMessage) -> {
            response.setStatusCode(status.intValue());
            if (status >= 400) {
                HttpUtils.setResponseBody(response, responseMessage.getJsonPayload());
            } else if (successfulOutcomeFilter.test((int)status)) {
                JsonArray credentials = responseMessage.getJsonPayload().getJsonArray("credentials");
                HttpUtils.setResponseBody(response, credentials);
            }
            response.end();
        };
    }
}

