/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.credentials;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.service.http.TracingHandler;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.credentials.CommonCredential;
import org.eclipse.hono.service.management.credentials.CredentialsManagementService;
import org.eclipse.hono.service.management.credentials.GenericCredential;
import org.eclipse.hono.service.management.credentials.PasswordCredential;
import org.eclipse.hono.service.management.credentials.PskCredential;
import org.eclipse.hono.service.management.credentials.X509CertificateCredential;
import org.eclipse.hono.tracing.TracingHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCredentialsManagementHttpEndpoint
extends AbstractHttpEndpoint<ServiceConfigProperties> {
    private static final String SPAN_NAME_GET_CREDENTIALS = "get Credentials from management API";
    private static final String SPAN_NAME_UPDATE_CREDENTIALS = "update Credentials from management API";
    private static final String CREDENTIALS_MANAGEMENT_ENDPOINT_NAME = String.format("%s/%s", "v1", "credentials");

    @Autowired
    public AbstractCredentialsManagementHttpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    public String getName() {
        return CREDENTIALS_MANAGEMENT_ENDPOINT_NAME;
    }

    @Override
    public void addRoutes(Router router) {
        String pathWithTenantAndDeviceId = String.format("/%s/:%s/:%s", this.getName(), "tenant_id", "device_id");
        router.route(pathWithTenantAndDeviceId).handler((Handler)this.createCorsHandler(this.config.getCorsAllowedOrigin(), EnumSet.of(HttpMethod.GET, HttpMethod.PUT)));
        BodyHandler bodyHandler = BodyHandler.create();
        bodyHandler.setBodyLimit((long)this.config.getMaxPayloadSize());
        router.get(pathWithTenantAndDeviceId).handler(this::getCredentialsForDevice);
        router.put(pathWithTenantAndDeviceId).handler((Handler)bodyHandler);
        router.put(pathWithTenantAndDeviceId).handler(this::extractRequiredJsonArrayPayload);
        router.put(pathWithTenantAndDeviceId).handler(this::extractIfMatchVersionParam);
        router.put(pathWithTenantAndDeviceId).handler(this::updateCredentials);
    }

    protected abstract CredentialsManagementService getService();

    private void updateCredentials(RoutingContext ctx) {
        List<CommonCredential> commonCredentials;
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(ctx), (String)SPAN_NAME_UPDATE_CREDENTIALS, (String)this.getClass().getSimpleName()).start();
        JsonArray credentials = (JsonArray)ctx.get("KEY_REQUEST_BODY");
        String tenantId = this.getMandatoryRequestParam("tenant_id", ctx, span);
        String deviceId = this.getMandatoryRequestParam("device_id", ctx, span);
        Optional<String> resourceVersion = Optional.ofNullable((String)ctx.get("KEY_RESOURCE_VERSION"));
        try {
            commonCredentials = this.decodeCredentials(credentials);
        }
        catch (IllegalArgumentException e) {
            String msg = "Error parsing credentials";
            this.logger.debug("Error parsing credentials");
            TracingHelper.logError((Span)span, (String)"Error parsing credentials");
            Tags.HTTP_STATUS.set(span, Integer.valueOf(400));
            HttpUtils.badRequest(ctx, "Error parsing credentials");
            span.finish();
            return;
        }
        this.logger.debug("updating credentials [tenant: {}, device-id: {}] - {}", new Object[]{tenantId, deviceId, credentials});
        this.getService().updateCredentials(tenantId, deviceId, commonCredentials, resourceVersion, span).setHandler(handler -> {
            OperationResult operationResult = (OperationResult)handler.result();
            this.writeOperationResponse(ctx, operationResult, null, span);
        });
    }

    private void getCredentialsForDevice(RoutingContext ctx) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(ctx), (String)SPAN_NAME_GET_CREDENTIALS, (String)this.getClass().getSimpleName()).start();
        String tenantId = this.getMandatoryRequestParam("tenant_id", ctx, span);
        String deviceId = this.getMandatoryRequestParam("device_id", ctx, span);
        HttpServerResponse response = ctx.response();
        this.logger.debug("getCredentialsForDevice [tenant: {}, device-id: {}]]", (Object)tenantId, (Object)deviceId);
        this.getService().readCredentials(tenantId, deviceId, span).setHandler(handler -> {
            OperationResult operationResult = (OperationResult)handler.result();
            int status = operationResult.getStatus();
            response.setStatusCode(status);
            switch (status) {
                case 200: {
                    JsonArray credentialsArray = new JsonArray();
                    for (CommonCredential credential : (List)operationResult.getPayload()) {
                        credentialsArray.add(JsonObject.mapFrom((Object)credential));
                    }
                    operationResult.getResourceVersion().ifPresent(v -> response.putHeader(HttpHeaders.ETAG, (CharSequence)v));
                    HttpUtils.setResponseBody(response, credentialsArray);
                }
            }
            Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
            span.finish();
            response.end();
        });
    }

    protected List<CommonCredential> decodeCredentials(JsonArray objects) {
        return objects.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(this::decodeCredential).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected CommonCredential decodeCredential(JsonObject object) {
        if (object == null) {
            return null;
        }
        String type = object.getString("type");
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("'type' field must be set");
        }
        return this.decodeCredential(type, object);
    }

    protected CommonCredential decodeCredential(String type, JsonObject object) {
        switch (type) {
            case "hashed-password": {
                return (CommonCredential)object.mapTo(PasswordCredential.class);
            }
            case "psk": {
                return (CommonCredential)object.mapTo(PskCredential.class);
            }
            case "x509-cert": {
                return (CommonCredential)object.mapTo(X509CertificateCredential.class);
            }
        }
        return (CommonCredential)object.mapTo(GenericCredential.class);
    }
}

