/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.authentication.app;

import io.smallrye.config.ConfigMapping;
import io.vertx.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import org.eclipse.hono.authentication.file.FileBasedAuthenticationServiceConfigProperties;
import org.eclipse.hono.authentication.file.FileBasedAuthenticationServiceOptions;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.config.ServiceOptions;
import org.eclipse.hono.service.auth.AuthTokenFactory;
import org.eclipse.hono.service.auth.JjwtBasedAuthTokenFactory;

@ApplicationScoped
public final class PropertiesProducer {
    @Produces
    @Singleton
    FileBasedAuthenticationServiceConfigProperties properties(FileBasedAuthenticationServiceOptions options) {
        return new FileBasedAuthenticationServiceConfigProperties(options);
    }

    @Produces
    @Singleton
    ServiceConfigProperties serviceConfigProperties(@ConfigMapping(prefix="hono.auth.amqp") ServiceOptions options) {
        return new ServiceConfigProperties(options);
    }

    @Produces
    @Singleton
    AuthTokenFactory authTokenFactory(Vertx vertx, ServiceConfigProperties amqpProps, FileBasedAuthenticationServiceConfigProperties serviceConfig) {
        if (!serviceConfig.getSigning().isAppropriateForCreating() && amqpProps.getKeyPath() != null && amqpProps.getCertPath() != null) {
            serviceConfig.getSigning().setKeyPath(amqpProps.getKeyPath());
            serviceConfig.getSigning().setCertPath(amqpProps.getCertPath());
        }
        return new JjwtBasedAuthTokenFactory(vertx, serviceConfig.getSigning());
    }
}

