/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.authentication;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Objects;
import org.eclipse.hono.authentication.AuthenticationServerMetrics;
import org.eclipse.hono.service.auth.AuthenticationService;

public final class MicrometerBasedAuthenticationServerMetrics
implements AuthenticationServerMetrics {
    private static final String METER_AUTHENTICATION_ATTEMPTS = "hono.authentication.attempts";
    private final MeterRegistry meterRegistry;

    public MicrometerBasedAuthenticationServerMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry);
    }

    @Override
    public void reportConnectionAttempt(AuthenticationService.AuthenticationAttemptOutcome outcome) {
        this.reportConnectionAttempt(outcome, AuthenticationServerMetrics.ClientType.UNKNOWN);
    }

    @Override
    public void reportConnectionAttempt(AuthenticationService.AuthenticationAttemptOutcome outcome, AuthenticationServerMetrics.ClientType clientType) {
        Objects.requireNonNull(outcome);
        Objects.requireNonNull(clientType);
        this.meterRegistry.counter(METER_AUTHENTICATION_ATTEMPTS, (Iterable)Tags.of((Tag[])new Tag[]{Tag.of((String)"outcome", (String)outcome.toString()), clientType.asTag()})).increment();
    }
}

