/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.example;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.impl.HonoClientImpl;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.connection.ConnectionFactory;
import org.eclipse.hono.connection.ConnectionFactoryImpl;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppConfiguration {
    private final int DEFAULT_ADDRESS_RESOLUTION_TIMEOUT = 2000;

    @Bean
    public Vertx vertx() {
        VertxOptions options = new VertxOptions().setWarningExceptionTime(1500000000L).setAddressResolverOptions(new AddressResolverOptions().setCacheNegativeTimeToLive(0).setCacheMaxTimeToLive(0).setRotateServers(true).setQueryTimeout(2000L));
        return Vertx.vertx((VertxOptions)options);
    }

    @ConfigurationProperties(prefix="hono.client")
    @Bean
    public ClientConfigProperties honoClientConfig() {
        ClientConfigProperties config = new ClientConfigProperties();
        return config;
    }

    @Bean
    public ConnectionFactory honoConnectionFactory() {
        return new ConnectionFactoryImpl(this.vertx(), this.honoClientConfig());
    }

    @Bean
    public HonoClient honoClient() {
        return new HonoClientImpl(this.vertx(), this.honoConnectionFactory(), this.honoClientConfig());
    }
}

