/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.devices;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpResponseHead;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.eclipse.hono.client.util.StatusCodeMapper;

public class HonoHttpDevice {
    public static final String DEVICE_AUTH_ID = "sensor1";
    public static final String DEVICE_PASSWORD = "hono-secret";
    public static final String HONO_HTTP_ADAPTER_HOST = "localhost";
    public static final int HONO_HTTP_ADAPTER_PORT = 8080;
    public static final String TENANT_ID = "DEFAULT_TENANT";
    protected static final String ORIGIN_URI = "http://hono.eclipse.org";
    private static final Vertx VERTX = Vertx.vertx();
    private static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private final List<Request> requests = List.of(Request.EMPTY_EVENT_WITH_TTD, Request.EMPTY_EVENT_WITH_TTD, Request.EMPTY_EVENT_WITH_TTD, Request.TELEMETRY_WITHOUT_TTD, Request.EMPTY_EVENT_WITH_TTD, Request.TELEMETRY_WITHOUT_TTD, Request.JSON_EVENT_WITH_TTD, Request.TELEMETRY_WITHOUT_TTD, Request.JSON_EVENT_WITHOUT_TTD, Request.EMPTY_EVENT_ALREADY_INVALID, Request.TELEMETRY_WITH_TTD, Request.TELEMETRY_WITHOUT_TTD);
    private final HttpClient httpClient;
    private final MultiMap standardRequestHeaders;

    private HonoHttpDevice() {
        HttpClientOptions options = new HttpClientOptions();
        options.setDefaultHost(HONO_HTTP_ADAPTER_HOST);
        options.setDefaultPort(8080);
        this.httpClient = VERTX.createHttpClient(options);
        this.standardRequestHeaders = MultiMap.caseInsensitiveMultiMap().add(HttpHeaders.AUTHORIZATION, (CharSequence)HonoHttpDevice.getBasicAuth(TENANT_ID, DEVICE_AUTH_ID, DEVICE_PASSWORD)).add(HttpHeaders.ORIGIN, (CharSequence)ORIGIN_URI);
    }

    public static void main(String[] args) {
        HonoHttpDevice httpDevice = new HonoHttpDevice();
        httpDevice.sendData();
        VERTX.setTimer(2000L, timerId -> VERTX.close());
    }

    private CompletableFuture<Void> sendMessage(Request request) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        this.httpClient.request(HttpMethod.POST, request.isEvent ? "/event" : "/telemetry").map(httpRequest -> {
            httpRequest.headers().addAll(this.standardRequestHeaders).addAll(request.getHeaders());
            return httpRequest;
        }).compose(httpRequest -> httpRequest.send(Optional.ofNullable(request.payload).map(Buffer::buffer).orElseGet(Buffer::buffer))).onFailure(result::completeExceptionally).onSuccess(response -> {
            System.out.println(response.statusCode() + " " + response.statusMessage());
            if (StatusCodeMapper.isSuccessful((Integer)response.statusCode())) {
                MultiMap resultMap = response.headers();
                resultMap.entries().stream().forEach(entry -> System.out.println(String.format("%s: %s", entry.getKey(), entry.getValue())));
                response.bodyHandler(b -> {
                    if (b.length() > 0) {
                        System.out.println();
                        System.out.println(b.toString());
                    }
                });
                String commandReqId = response.headers().get("hono-cmd-req-id");
                if (commandReqId == null) {
                    VERTX.setTimer(1000L, l -> result.complete(null));
                } else {
                    this.sendCommandResponse(commandReqId, 200, Buffer.buffer((String)"ok"), "text/plain").map(status -> {
                        System.out.println(String.format("sent response to command [HTTP response status: %d]", status));
                        VERTX.setTimer(1000L, l -> result.complete(null));
                        return null;
                    });
                }
            } else {
                result.completeExceptionally((Throwable)StatusCodeMapper.from((int)response.statusCode(), (String)response.statusMessage()));
            }
        });
        return result;
    }

    private Future<Integer> sendCommandResponse(String commandReqId, int status, Buffer payload, String contentType) {
        return this.httpClient.request(HttpMethod.POST, String.format("/%s/res/%s", "command", commandReqId)).map(httpRequest -> {
            httpRequest.putHeader("hono-cmd-status", Integer.toString(status));
            Optional.ofNullable(contentType).ifPresent(ct -> httpRequest.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)ct));
            httpRequest.headers().addAll(this.standardRequestHeaders);
            return httpRequest;
        }).compose(httpRequest -> payload == null ? httpRequest.send() : httpRequest.send(payload)).map(HttpResponseHead::statusCode);
    }

    protected void sendData() {
        System.out.println(String.format("Total number of requests to send: %s", this.requests.size()));
        this.requests.stream().forEachOrdered(request -> {
            System.out.println();
            System.out.println();
            System.out.println(String.format("Sending request [type: %s] ...", request.toString()));
            CompletableFuture<Void> responseFuture = this.sendMessage((Request)((Object)request));
            try {
                responseFuture.join();
            }
            catch (CompletionException e) {
                System.err.println("error sending request to HTTP adapter: " + e.getMessage());
            }
        });
    }

    private static String getBasicAuth(String tenant, String deviceId, String password) {
        StringBuilder result = new StringBuilder("Basic ");
        String username = HonoHttpDevice.getUsername(deviceId, tenant);
        result.append(Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8)));
        return result.toString();
    }

    private static String getUsername(String deviceId, String tenant) {
        return String.format("%s@%s", deviceId, tenant);
    }

    private static enum Request {
        EMPTY_EVENT_WITH_TTD(null, "application/vnd.eclipse-hono-empty-notification", 60, true),
        EMPTY_EVENT_ALREADY_INVALID(null, "application/vnd.eclipse-hono-empty-notification", 0, true),
        JSON_EVENT_WITHOUT_TTD(new JsonObject().put("threshold", (Object)"exceeded"), "application/json", null, true),
        JSON_EVENT_WITH_TTD(new JsonObject().put("threshold", (Object)"exceeded"), "application/json", 120, true),
        TELEMETRY_WITHOUT_TTD(new JsonObject().put("weather", (Object)"sunny"), "application/json", null, false),
        TELEMETRY_WITH_TTD(new JsonObject().put("weather", (Object)"cloudy"), "application/json", 60, false);

        private final String payload;
        private final String contentType;
        private final Integer ttd;
        private final boolean isEvent;

        private Request(JsonObject payload, String contentType, Integer ttd, boolean isEvent) {
            this.payload = Optional.ofNullable(payload).map(JsonObject::encode).orElse(null);
            this.contentType = contentType;
            this.ttd = ttd;
            this.isEvent = isEvent;
        }

        public MultiMap getHeaders() {
            MultiMap headers = MultiMap.caseInsensitiveMultiMap();
            headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)this.contentType);
            if (this.ttd != null) {
                headers.add("hono-ttd", this.ttd.toString());
            }
            return headers;
        }

        public String toString() {
            return String.format("%s [content type: %s, ttd: %d, is event: %b, payload: %s]", this.name(), this.contentType, this.ttd, this.isEvent, this.payload);
        }
    }
}

