/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.telemetry.amqp;

import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.amqp.DownstreamAmqpMessageFactory;
import org.eclipse.hono.client.amqp.SenderCachingServiceClient;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.amqp.connection.SendMessageSampler;
import org.eclipse.hono.client.telemetry.EventSender;
import org.eclipse.hono.client.telemetry.TelemetrySender;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.TenantObject;

public class ProtonBasedDownstreamSender
extends SenderCachingServiceClient
implements TelemetrySender,
EventSender {
    private final boolean deviceDefaultsEnabled;
    private final boolean jmsVendorPropsEnabled;

    public ProtonBasedDownstreamSender(HonoConnection connection, SendMessageSampler.Factory samplerFactory, boolean deviceDefaultsEnabled, boolean jmsVendorPropsEnabled) {
        super(connection, samplerFactory);
        this.deviceDefaultsEnabled = deviceDefaultsEnabled;
        this.jmsVendorPropsEnabled = jmsVendorPropsEnabled;
    }

    public Future<Void> sendTelemetry(TenantObject tenant, RegistrationAssertion device, QoS qos, String contentType, Buffer payload, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(device);
        Objects.requireNonNull(qos);
        return this.getOrCreateSenderLink("telemetry", tenant.getTenantId()).recover(thr -> Future.failedFuture((Throwable)StatusCodeMapper.toServerError((Throwable)thr))).compose(sender -> {
            ResourceIdentifier target = ResourceIdentifier.from((String)"telemetry", (String)tenant.getTenantId(), (String)device.getDeviceId());
            Message message = this.createMessage(tenant, device, qos, target, contentType, payload, properties);
            switch (qos) {
                case AT_MOST_ONCE: {
                    return sender.send(message, this.newFollowingSpan(context, "forward Telemetry data"));
                }
            }
            return sender.sendAndWaitForOutcome(message, this.newChildSpan(context, "forward Telemetry data"));
        }).mapEmpty();
    }

    public Future<Void> sendEvent(TenantObject tenant, RegistrationAssertion device, String contentType, Buffer payload, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(device);
        return this.getOrCreateSenderLink("event", tenant.getTenantId()).recover(thr -> Future.failedFuture((Throwable)StatusCodeMapper.toServerError((Throwable)thr))).compose(sender -> {
            ResourceIdentifier target = ResourceIdentifier.from((String)"event", (String)tenant.getTenantId(), (String)device.getDeviceId());
            Message message = this.createMessage(tenant, device, QoS.AT_LEAST_ONCE, target, contentType, payload, properties);
            message.setDurable(true);
            sender.setErrorInfoLoggingEnabled(true);
            return sender.sendAndWaitForOutcome(message, this.newChildSpan(context, "forward Event"));
        }).mapEmpty();
    }

    private Message createMessage(TenantObject tenant, RegistrationAssertion device, QoS qos, ResourceIdentifier target, String contentType, Buffer payload, Map<String, Object> properties) {
        Map props = Optional.ofNullable(properties).orElseGet(HashMap::new);
        props.put("qos", qos.ordinal());
        props.put("device_id", device.getDeviceId());
        return DownstreamAmqpMessageFactory.newMessage((ResourceIdentifier)target, (String)contentType, (Buffer)payload, (TenantObject)tenant, (Map)(this.deviceDefaultsEnabled ? tenant.getDefaults().getMap() : null), (Map)(this.deviceDefaultsEnabled ? device.getDefaults() : null), (Map)props, (boolean)this.jmsVendorPropsEnabled);
    }

    public String toString() {
        return ProtonBasedDownstreamSender.class.getName() + " via AMQP 1.0 Messaging Network";
    }
}

