/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.pubsub.publisher;

import com.google.api.gax.core.CredentialsProvider;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.pubsub.PubSubMessageHelper;
import org.eclipse.hono.client.pubsub.publisher.PubSubPublisherClient;
import org.eclipse.hono.client.pubsub.publisher.PubSubPublisherClientImpl;
import org.eclipse.hono.client.pubsub.publisher.PubSubPublisherFactory;

public final class CachingPubSubPublisherFactory
implements PubSubPublisherFactory {
    private final Vertx vertx;
    private final Map<String, PubSubPublisherClient> activePublishers = new ConcurrentHashMap<String, PubSubPublisherClient>();
    private final String projectId;
    private final CredentialsProvider credentialsProvider;
    private Supplier<PubSubPublisherClient> clientSupplier;

    public CachingPubSubPublisherFactory(Vertx vertx, String projectId, CredentialsProvider credentialsProvider) {
        this.vertx = Objects.requireNonNull(vertx);
        this.projectId = Objects.requireNonNull(projectId);
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider);
    }

    public void setClientSupplier(Supplier<PubSubPublisherClient> supplier) {
        this.clientSupplier = supplier;
    }

    @Override
    public Future<Void> closePublisher(String topic) {
        return this.removePublisher(topic);
    }

    @Override
    public Future<Void> closePublisher(String topic, String prefix) {
        String topicName = PubSubMessageHelper.getTopicName(topic, prefix);
        return this.removePublisher(topicName);
    }

    @Override
    public Future<Void> closeAllPublisher() {
        this.activePublishers.forEach((k, v) -> this.removePublisher((String)k));
        if (this.activePublishers.size() == 0) {
            return Future.succeededFuture();
        }
        return Future.failedFuture((Throwable)new ServerErrorException(503, "Failed to close all publisher"));
    }

    @Override
    public PubSubPublisherClient getOrCreatePublisher(String topic) {
        return this.activePublishers.computeIfAbsent(topic, s -> this.getPubSubPublisherClient(topic));
    }

    @Override
    public Optional<PubSubPublisherClient> getPublisher(String topic, String prefix) {
        String topicTenantName = PubSubMessageHelper.getTopicName(topic, prefix);
        return Optional.ofNullable(this.activePublishers.get(topicTenantName));
    }

    private PubSubPublisherClient getPubSubPublisherClient(String topic) {
        return Optional.ofNullable(this.clientSupplier).map(Supplier::get).orElseGet(() -> new PubSubPublisherClientImpl(this.vertx, this.projectId, topic, this.credentialsProvider));
    }

    private Future<Void> removePublisher(String topicName) {
        PubSubPublisherClient publisher = this.activePublishers.remove(topicName);
        if (publisher != null) {
            try {
                publisher.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Future.succeededFuture();
    }
}

