/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.pubsub;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.pubsub.PubSubPublisherClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PubSubPublisherClientImpl
implements PubSubPublisherClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Publisher publisher;

    PubSubPublisherClientImpl(String projectId, String topic, CredentialsProvider credentialsProvider) throws ClientErrorException {
        Objects.requireNonNull(projectId);
        Objects.requireNonNull(topic);
        TopicName topicName = TopicName.of((String)projectId, (String)topic);
        Publisher.Builder builder = Publisher.newBuilder((TopicName)topicName).setEnableMessageOrdering(true);
        Optional.ofNullable(credentialsProvider).ifPresent(arg_0 -> ((Publisher.Builder)builder).setCredentialsProvider(arg_0));
        try {
            this.publisher = builder.build();
        }
        catch (IOException e) {
            this.publisher = null;
            this.log.debug("Error initializing publisher client: {}", (Object)e.getMessage());
            throw new ClientErrorException(409, "Publisher client is null", (Throwable)e);
        }
    }

    @Override
    public void close() {
        Context currentContext = Vertx.currentContext();
        if (currentContext == null) {
            throw new IllegalStateException("Client is not running on a Vert.x Context");
        }
        currentContext.executeBlocking(blockingHandler -> {
            if (this.publisher != null) {
                this.publisher.shutdown();
                try {
                    this.publisher.awaitTermination(1L, TimeUnit.MINUTES);
                    blockingHandler.complete();
                }
                catch (InterruptedException e) {
                    this.log.debug("Resources are not freed properly, error", (Throwable)e);
                    Thread.currentThread().interrupt();
                    blockingHandler.fail((Throwable)e);
                }
            }
        });
    }

    @Override
    public Future<String> publish(PubsubMessage pubsubMessage) {
        final Promise result = Promise.promise();
        ApiFuture messageIdFuture = this.publisher.publish(pubsubMessage);
        ApiFutures.addCallback((ApiFuture)messageIdFuture, (ApiFutureCallback)new ApiFutureCallback<String>(){

            public void onSuccess(String messageId) {
                result.complete((Object)messageId);
            }

            public void onFailure(Throwable t) {
                PubSubPublisherClientImpl.this.log.debug("Error publishing messages to Pub/Sub", t);
                result.fail(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result.future();
    }
}

