/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.notification.deviceregistry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.annotation.HonoTimestamp;
import org.eclipse.hono.notification.AbstractNotification;
import org.eclipse.hono.notification.NotificationType;

@RegisterForReflection
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class CredentialsChangeNotification
extends AbstractNotification {
    public static final String TYPE_NAME = "credentials-change-v1";
    public static final String ADDRESS = "registry-device";
    public static final NotificationType<CredentialsChangeNotification> TYPE = new NotificationType<CredentialsChangeNotification>("credentials-change-v1", CredentialsChangeNotification.class, "registry-device");
    private final String tenantId;
    private final String deviceId;

    @JsonCreator
    CredentialsChangeNotification(@JsonProperty(value="source", required=true) String source, @JsonProperty(value="creation-time", required=true) @HonoTimestamp Instant creationTime, @JsonProperty(value="tenant-id", required=true) String tenantId, @JsonProperty(value="device-id", required=true) String deviceId) {
        super(source, creationTime);
        this.tenantId = Objects.requireNonNull(tenantId);
        this.deviceId = Objects.requireNonNull(deviceId);
    }

    public CredentialsChangeNotification(String tenantId, String deviceId, Instant creationTime) {
        this("device-registry", creationTime, tenantId, deviceId);
    }

    @JsonProperty(value="tenant-id")
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="device-id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonIgnore
    public NotificationType<CredentialsChangeNotification> getType() {
        return TYPE;
    }

    @Override
    @JsonIgnore
    public String getKey() {
        return this.getDeviceId();
    }

    public String toString() {
        return "CredentialsChangeNotification{tenantId='" + this.tenantId + "', deviceId='" + this.deviceId + "', creationTime='" + String.valueOf(this.getCreationTime()) + "'}";
    }
}

