/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.notification.pubsub;

import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.pubsub.AbstractPubSubBasedMessageSender;
import org.eclipse.hono.client.pubsub.PubSubMessageHelper;
import org.eclipse.hono.client.pubsub.publisher.PubSubPublisherFactory;
import org.eclipse.hono.notification.AbstractNotification;
import org.eclipse.hono.notification.NotificationSender;

public class PubSubBasedNotificationSender
extends AbstractPubSubBasedMessageSender
implements NotificationSender {
    private static final String TOPIC_ENDPOINT = "notification";

    public PubSubBasedNotificationSender(PubSubPublisherFactory publisherFactory, String projectId, Tracer tracer) {
        super(publisherFactory, TOPIC_ENDPOINT, projectId, tracer);
    }

    public Future<Void> publish(AbstractNotification notification) {
        Objects.requireNonNull(notification);
        if (!this.lifecycleStatus.isStarted()) {
            return Future.failedFuture((Throwable)new ServerErrorException(503, "sender not started"));
        }
        String topic = PubSubMessageHelper.getTopicName((String)TOPIC_ENDPOINT, (String)notification.getType().getAddress());
        return this.createPubSubMessage(notification).compose(message -> {
            this.log.debug("sending notification to Pub/Sub [topic: {}, key: {}]", (Object)topic, (Object)notification.getKey());
            return this.getOrCreatePublisher(topic).publish(message).recover(t -> {
                this.log.error("error publishing notification to Pub/Sub for notification [{}]", (Object)notification, t);
                return Future.failedFuture((Throwable)new ServerErrorException(503, t));
            });
        }).mapEmpty();
    }

    private Future<PubsubMessage> createPubSubMessage(AbstractNotification notification) {
        try {
            JsonObject value = JsonObject.mapFrom((Object)notification);
            ByteString data = ByteString.copyFrom((byte[])value.toBuffer().getBytes());
            return Future.succeededFuture((Object)PubsubMessage.newBuilder().setOrderingKey(notification.getType().getAddress()).setData(data).build());
        }
        catch (RuntimeException e) {
            this.log.error("error creating Pub/Sub message for notification {}", (Object)notification, (Object)e);
            return Future.failedFuture((Throwable)new ServerErrorException(500, (Throwable)e));
        }
    }
}

