/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.util;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.hono.client.ServerErrorException;

public class ClientFactory<T> {
    protected final List<Handler<ServerErrorException>> creationRequests = new ArrayList<Handler<ServerErrorException>>();

    public final void onDisconnect() {
        ServerErrorException connectionLostException = new ServerErrorException(503, "no connection to service");
        this.failAllCreationRequests(connectionLostException);
        this.doClearStateAfterCreationRequestsCleared();
    }

    private void failAllCreationRequests(ServerErrorException exception) {
        Iterator<Handler<ServerErrorException>> iter = this.creationRequests.iterator();
        while (iter.hasNext()) {
            iter.next().handle((Object)exception);
            iter.remove();
        }
    }

    protected void doClearStateAfterCreationRequestsCleared() {
    }

    public final void createClient(Supplier<Future<T>> clientSupplier, Handler<AsyncResult<T>> result) {
        Handler connectionFailureHandler = connectionLostException -> result.handle((Object)Future.failedFuture((Throwable)connectionLostException));
        this.creationRequests.add((Handler<ServerErrorException>)connectionFailureHandler);
        clientSupplier.get().onComplete(attempt -> {
            this.creationRequests.remove(connectionFailureHandler);
            result.handle(attempt);
        });
    }
}

