/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.util;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.util.ClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachingClientFactory<T>
extends ClientFactory<T> {
    private static final Logger log = LoggerFactory.getLogger(CachingClientFactory.class);
    private static final int WAITING_CREATION_REQUESTS_COMPLETION_BATCH_SIZE_DEFAULT = 10;
    private final Vertx vertx;
    private final Predicate<T> livenessCheck;
    private final Map<String, T> activeClients = new HashMap<String, T>();
    private final Map<String, Boolean> creationLocks = new HashMap<String, Boolean>();
    private final List<CreationRequestData> waitingCreationRequests = new LinkedList<CreationRequestData>();
    private final Set<String> keysOfBeingCompletedConcurrentCreationRequests = new HashSet<String>();
    private int waitingCreationRequestsCompletionBatchSize = 10;

    public CachingClientFactory(Vertx vertx, Predicate<T> livenessCheck) {
        this.vertx = vertx;
        this.livenessCheck = Objects.requireNonNull(livenessCheck);
    }

    void setWaitingCreationRequestsCompletionBatchSize(int waitingCreationRequestsCompletionBatchSize) {
        this.waitingCreationRequestsCompletionBatchSize = waitingCreationRequestsCompletionBatchSize;
    }

    public void removeClient(String key) {
        this.activeClients.remove(key);
    }

    public void removeClient(String key, Handler<T> postProcessor) {
        T client = this.activeClients.remove(key);
        if (client != null) {
            postProcessor.handle(client);
        }
    }

    @Override
    protected void doClearStateAfterCreationRequestsCleared() {
        this.activeClients.clear();
        this.creationLocks.clear();
    }

    public T getClient(String key) {
        return this.activeClients.get(key);
    }

    public void getOrCreateClient(String key, Supplier<Future<T>> clientInstanceSupplier, Handler<AsyncResult<T>> result) {
        if (this.keysOfBeingCompletedConcurrentCreationRequests.contains(key)) {
            log.debug("delaying client creation request, previous requests still being finished for [{}] ({} waiting creation requests for all keys)", (Object)key, (Object)this.waitingCreationRequests.size());
            this.waitingCreationRequests.add(new CreationRequestData(key, clientInstanceSupplier, result));
            return;
        }
        T sender = this.activeClients.get(key);
        if (sender != null && this.livenessCheck.test(sender)) {
            log.debug("reusing cached client [{}]", (Object)key);
            result.handle((Object)Future.succeededFuture(sender));
            return;
        }
        if (this.creationLocks.putIfAbsent(key, Boolean.TRUE) == null) {
            Handler connectionFailureHandler = connectionLostException -> {
                if (this.creationLocks.remove(key, Boolean.TRUE)) {
                    log.debug("failed to create new client for [{}]: {}", (Object)key, (Object)connectionLostException.toString());
                    result.handle((Object)Future.failedFuture((Throwable)connectionLostException));
                    this.failWaitingCreationRequests(key, (Throwable)connectionLostException);
                } else {
                    log.debug("creation attempt already finished for [{}]", (Object)key);
                }
            };
            this.creationRequests.add(connectionFailureHandler);
            log.debug("creating new client for [{}]", (Object)key);
            Future<T> clientInstanceSupplierFuture = null;
            try {
                clientInstanceSupplierFuture = clientInstanceSupplier.get();
                if (clientInstanceSupplierFuture == null) {
                    throw new NullPointerException("clientInstanceSupplier result is null");
                }
            }
            catch (Exception ex) {
                this.creationLocks.remove(key);
                this.creationRequests.remove(connectionFailureHandler);
                log.error("exception creating new client for [{}]", (Object)key, (Object)ex);
                this.activeClients.remove(key);
                ServerErrorException exception = new ServerErrorException(500, String.format("exception creating new client for [%s]: %s", key, ex.getMessage()));
                result.handle((Object)Future.failedFuture((Throwable)exception));
                this.failWaitingCreationRequests(key, exception);
            }
            if (clientInstanceSupplierFuture != null) {
                clientInstanceSupplierFuture.onComplete(creationAttempt -> {
                    this.creationRequests.remove(connectionFailureHandler);
                    if (this.creationLocks.remove(key, Boolean.TRUE)) {
                        if (creationAttempt.succeeded()) {
                            Object newClient = creationAttempt.result();
                            log.debug("successfully created new client for [{}]", (Object)key);
                            this.activeClients.put(key, newClient);
                            result.handle((Object)Future.succeededFuture((Object)newClient));
                            this.processWaitingCreationRequests();
                        } else {
                            log.debug("failed to create new client for [{}]", (Object)key, (Object)creationAttempt.cause());
                            this.activeClients.remove(key);
                            result.handle((Object)Future.failedFuture((Throwable)creationAttempt.cause()));
                            this.failWaitingCreationRequests(key, creationAttempt.cause());
                        }
                    } else {
                        log.debug("creation attempt already finished for [{}]", (Object)key);
                    }
                });
            }
        } else {
            this.waitingCreationRequests.add(new CreationRequestData(key, clientInstanceSupplier, result));
            log.debug("already trying to create a client for [{}] ({} waiting creation requests for all keys)", (Object)key, (Object)this.waitingCreationRequests.size());
        }
    }

    private void failWaitingCreationRequests(String key, Throwable cause) {
        int count = 0;
        Iterator<CreationRequestData> iter = this.waitingCreationRequests.iterator();
        while (iter.hasNext()) {
            CreationRequestData creationRequestData = iter.next();
            if (!key.equals(creationRequestData.key)) continue;
            iter.remove();
            ++count;
            creationRequestData.result.handle((Object)Future.failedFuture((Throwable)cause));
        }
        this.keysOfBeingCompletedConcurrentCreationRequests.remove(key);
        if (count > 0 && log.isDebugEnabled()) {
            log.debug("failed {} concurrent requests to create new client for [{}]: {}", new Object[]{count, key, cause.toString()});
        }
    }

    private void processWaitingCreationRequests() {
        int removedEntriesCount = 0;
        this.keysOfBeingCompletedConcurrentCreationRequests.clear();
        Iterator<CreationRequestData> iter = this.waitingCreationRequests.iterator();
        while (iter.hasNext()) {
            CreationRequestData creationRequestData = iter.next();
            if (this.creationLocks.containsKey(creationRequestData.key)) continue;
            if (removedEntriesCount < this.waitingCreationRequestsCompletionBatchSize) {
                iter.remove();
                ++removedEntriesCount;
                this.getOrCreateClient(creationRequestData.key, creationRequestData.clientInstanceSupplier, creationRequestData.result);
                continue;
            }
            this.keysOfBeingCompletedConcurrentCreationRequests.add(creationRequestData.key);
        }
        if (!this.keysOfBeingCompletedConcurrentCreationRequests.isEmpty()) {
            log.trace("decoupling completion of remaining waiting creation requests");
            this.vertx.runOnContext(v -> this.processWaitingCreationRequests());
        } else if (!this.waitingCreationRequests.isEmpty()) {
            log.trace("no more waiting creation requests to complete at this time ({} remaining requests overall)", (Object)this.waitingCreationRequests.size());
        }
    }

    private class CreationRequestData {
        final String key;
        final Supplier<Future<T>> clientInstanceSupplier;
        final Handler<AsyncResult<T>> result;

        CreationRequestData(String key, Supplier<Future<T>> clientInstanceSupplier, Handler<AsyncResult<T>> result) {
            this.key = key;
            this.clientInstanceSupplier = clientInstanceSupplier;
            this.result = result;
        }
    }
}

