/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.hono.client.command.KubernetesContainerInfoProvider;
import org.eclipse.hono.util.Pair;
import org.eclipse.hono.util.Strings;

public class CommandRoutingUtil {
    private static final Pattern KUBERNETES_ADAPTER_INSTANCE_ID_PATTERN = Pattern.compile("^(.*)_([0-9a-f]{12})_\\d+$");

    private CommandRoutingUtil() {
    }

    public static String getNewAdapterInstanceId(String adapterName, String k8sContainerId, int counter) {
        if (k8sContainerId == null || k8sContainerId.length() < 12) {
            return CommandRoutingUtil.getNewAdapterInstanceIdForNonK8sEnv(adapterName);
        }
        String prefix = KubernetesContainerInfoProvider.getInstance().getPodName();
        if (Strings.isNullOrEmpty((Object)prefix)) {
            prefix = adapterName;
        }
        return CommandRoutingUtil.getNewAdapterInstanceIdForK8sEnv(prefix, k8sContainerId, counter);
    }

    public static String getNewAdapterInstanceIdForNonK8sEnv(String adapterName) {
        String prefix = Strings.isNullOrEmpty((Object)adapterName) ? "" : adapterName.replaceAll("[^a-zA-Z0-9._-]", "") + "-";
        return prefix + UUID.randomUUID();
    }

    public static String getNewAdapterInstanceIdForK8sEnv(String podName, String containerId, int counter) {
        Objects.requireNonNull(containerId);
        String podNameToUse = Optional.ofNullable(podName).map(p -> p.replaceAll("[^a-zA-Z0-9._-]", "")).orElse("");
        return String.format("%s_%s_%d", podNameToUse, containerId.substring(0, 12), counter);
    }

    public static Pair<String, String> getK8sPodNameAndContainerIdFromAdapterInstanceId(String adapterInstanceId) {
        Objects.requireNonNull(adapterInstanceId);
        Matcher matcher = KUBERNETES_ADAPTER_INSTANCE_ID_PATTERN.matcher(adapterInstanceId);
        if (!matcher.matches()) {
            return null;
        }
        return Pair.of((Object)matcher.group(1), (Object)matcher.group(2));
    }
}

