/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command;

import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.command.CommandRouterClient;
import org.eclipse.hono.client.command.DeviceConnectionClient;
import org.eclipse.hono.client.util.ServiceClient;

public final class DeviceConnectionClientAdapter
implements CommandRouterClient,
ServiceClient {
    private final DeviceConnectionClient deviceConnectionClient;

    public DeviceConnectionClientAdapter(DeviceConnectionClient client) {
        this.deviceConnectionClient = Objects.requireNonNull(client);
    }

    public Future<Void> stop() {
        return this.deviceConnectionClient.stop();
    }

    public Future<Void> start() {
        return this.deviceConnectionClient.start();
    }

    @Override
    public Future<Void> registerCommandConsumer(String tenantId, String deviceId, String adapterInstanceId, Duration lifespan, SpanContext context) {
        return this.deviceConnectionClient.setCommandHandlingAdapterInstance(tenantId, deviceId, adapterInstanceId, lifespan, context);
    }

    @Override
    public Future<Void> unregisterCommandConsumer(String tenantId, String deviceId, String adapterInstanceId, SpanContext context) {
        return this.deviceConnectionClient.removeCommandHandlingAdapterInstance(tenantId, deviceId, adapterInstanceId, context);
    }

    @Override
    public Future<Void> setLastKnownGatewayForDevice(String tenantId, String deviceId, String gatewayId, SpanContext context) {
        return this.deviceConnectionClient.setLastKnownGatewayForDevice(tenantId, deviceId, gatewayId, context);
    }

    @Override
    public Future<Void> enableCommandRouting(List<String> tenantIds, SpanContext context) {
        return Future.succeededFuture();
    }

    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        if (this.deviceConnectionClient instanceof ServiceClient) {
            ((ServiceClient)this.deviceConnectionClient).registerReadinessChecks(readinessHandler);
        }
    }

    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
        if (this.deviceConnectionClient instanceof ServiceClient) {
            ((ServiceClient)this.deviceConnectionClient).registerLivenessChecks(livenessHandler);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[deviceConnectionClient: " + this.deviceConnectionClient + "]";
    }
}

